/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a health source. A health source resource specifies the source resources and the
 * health aggregation policy applied to the source resources to determine the aggregated health
 * status.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HealthSource extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a HealthSource. An up-to-date
   * fingerprint must be provided in order to patch the HealthSource; Otherwise, the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to
   * retrieve the HealthSource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * URL to the HealthAggregationPolicy resource. Must be set. Must be regional and in the same
   * region as the HealthSource. Can be mutated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String healthAggregationPolicy;

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#healthSource for health sources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] URL of the region where the health source resides. This field applies only to the
   * regional resource. You must specify this field as part of the HTTP request URL. It is not
   * settable as a field in the request body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL with id for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * Specifies the type of the HealthSource. The only allowed value is BACKEND_SERVICE. Must be
   * specified when the HealthSource is created, and cannot be mutated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceType;

  /**
   * URLs to the source resources. Must be size 1. Must be a BackendService if the sourceType is
   * BACKEND_SERVICE. The BackendService must have load balancing scheme INTERNAL or
   * INTERNAL_MANAGED and must be regional and in the same region as the HealthSource (cross-region
   * deployment for INTERNAL_MANAGED is not supported). The BackendService may use only IGs, MIGs,
   * or NEGs of type GCE_VM_IP or GCE_VM_IP_PORT. The BackendService may not use haPolicy. Can be
   * mutated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sources;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public HealthSource setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public HealthSource setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a HealthSource. An up-to-date
   * fingerprint must be provided in order to patch the HealthSource; Otherwise, the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to
   * retrieve the HealthSource.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a HealthSource. An up-to-date
   * fingerprint must be provided in order to patch the HealthSource; Otherwise, the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to
   * retrieve the HealthSource.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a HealthSource. An up-to-date
   * fingerprint must be provided in order to patch the HealthSource; Otherwise, the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to
   * retrieve the HealthSource.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public HealthSource setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a HealthSource. An up-to-date
   * fingerprint must be provided in order to patch the HealthSource; Otherwise, the request will
   * fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to
   * retrieve the HealthSource.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public HealthSource encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * URL to the HealthAggregationPolicy resource. Must be set. Must be regional and in the same
   * region as the HealthSource. Can be mutated.
   * @return value or {@code null} for none
   */
  public java.lang.String getHealthAggregationPolicy() {
    return healthAggregationPolicy;
  }

  /**
   * URL to the HealthAggregationPolicy resource. Must be set. Must be regional and in the same
   * region as the HealthSource. Can be mutated.
   * @param healthAggregationPolicy healthAggregationPolicy or {@code null} for none
   */
  public HealthSource setHealthAggregationPolicy(java.lang.String healthAggregationPolicy) {
    this.healthAggregationPolicy = healthAggregationPolicy;
    return this;
  }

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * @param id id or {@code null} for none
   */
  public HealthSource setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#healthSource for health sources.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#healthSource for health sources.
   * @param kind kind or {@code null} for none
   */
  public HealthSource setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public HealthSource setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] URL of the region where the health source resides. This field applies only to the
   * regional resource. You must specify this field as part of the HTTP request URL. It is not
   * settable as a field in the request body.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the health source resides. This field applies only to the
   * regional resource. You must specify this field as part of the HTTP request URL. It is not
   * settable as a field in the request body.
   * @param region region or {@code null} for none
   */
  public HealthSource setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public HealthSource setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL with id for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL with id for the resource.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public HealthSource setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * Specifies the type of the HealthSource. The only allowed value is BACKEND_SERVICE. Must be
   * specified when the HealthSource is created, and cannot be mutated.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceType() {
    return sourceType;
  }

  /**
   * Specifies the type of the HealthSource. The only allowed value is BACKEND_SERVICE. Must be
   * specified when the HealthSource is created, and cannot be mutated.
   * @param sourceType sourceType or {@code null} for none
   */
  public HealthSource setSourceType(java.lang.String sourceType) {
    this.sourceType = sourceType;
    return this;
  }

  /**
   * URLs to the source resources. Must be size 1. Must be a BackendService if the sourceType is
   * BACKEND_SERVICE. The BackendService must have load balancing scheme INTERNAL or
   * INTERNAL_MANAGED and must be regional and in the same region as the HealthSource (cross-region
   * deployment for INTERNAL_MANAGED is not supported). The BackendService may use only IGs, MIGs,
   * or NEGs of type GCE_VM_IP or GCE_VM_IP_PORT. The BackendService may not use haPolicy. Can be
   * mutated.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSources() {
    return sources;
  }

  /**
   * URLs to the source resources. Must be size 1. Must be a BackendService if the sourceType is
   * BACKEND_SERVICE. The BackendService must have load balancing scheme INTERNAL or
   * INTERNAL_MANAGED and must be regional and in the same region as the HealthSource (cross-region
   * deployment for INTERNAL_MANAGED is not supported). The BackendService may use only IGs, MIGs,
   * or NEGs of type GCE_VM_IP or GCE_VM_IP_PORT. The BackendService may not use haPolicy. Can be
   * mutated.
   * @param sources sources or {@code null} for none
   */
  public HealthSource setSources(java.util.List<java.lang.String> sources) {
    this.sources = sources;
    return this;
  }

  @Override
  public HealthSource set(String fieldName, Object value) {
    return (HealthSource) super.set(fieldName, value);
  }

  @Override
  public HealthSource clone() {
    return (HealthSource) super.clone();
  }

}
