/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * LINT.IfChange Parameters used to create an InterconnectAttachment. This is similar to
 * InterconnectAttachment, but the region field used here is not output only and all other output
 * only fields are excluded.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput extends com.google.api.client.json.GenericJson {

  /**
   * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adminEnabled;

  /**
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type
   * DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner
   * that is operating the interconnect must set the bandwidth. Output only for PARTNER type,
   * mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: -
   * BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s -
   * BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5
   * Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bandwidth;

  /**
   * Single IPv4 address + prefix length to be configured on the cloud router interface for this
   * interconnect attachment. - Both candidate_cloud_router_ip_address and
   * candidate_customer_router_ip_address fields must be set or both must be unset. - Prefix length
   * of both candidate_cloud_router_ip_address and candidate_customer_router_ip_address must be the
   * same. - Max prefix length is 31.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String candidateCloudRouterIpAddress;

  /**
   * Single IPv6 address + prefix length to be configured on the cloud router interface for this
   * interconnect attachment. - Both candidate_cloud_router_ipv6_address and
   * candidate_customer_router_ipv6_address fields must be set or both must be unset. - Prefix
   * length of both candidate_cloud_router_ipv6_address and candidate_customer_router_ipv6_address
   * must be the same. - Max prefix length is 126.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String candidateCloudRouterIpv6Address;

  /**
   * Single IPv4 address + prefix length to be configured on the customer router interface for this
   * interconnect attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String candidateCustomerRouterIpAddress;

  /**
   * Single IPv6 address + prefix length to be configured on the customer router interface for this
   * interconnect attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String candidateCustomerRouterIpv6Address;

  /**
   * This field is not available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> candidateIpv6Subnets;

  /**
   * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of
   * cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be
   * within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc).
   * Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request
   * will fail if all possible /29s are in use on Google's edge. If not supplied, Google will
   * randomly select an unused /29 from all of link-local space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> candidateSubnets;

  /**
   * This field is not available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cloudRouterIpv6InterfaceId;

  /**
   * This field is not available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customerRouterIpv6InterfaceId;

  /**
   * An optional description of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Input only. Desired availability domain for the attachment. Only available for type PARTNER, at
   * creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY -
   * AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should
   * configure a pair of attachments, one per availability domain. The selected availability domain
   * will be provided to the Partner via the pairing key, so that the provisioned circuit will lie
   * in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String edgeAvailabilityDomain;

  /**
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment).
   * Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible
   * values are: - alpha - This is the default value, which means that the VLAN attachment carries
   * unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN
   * attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by
   * an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send
   * traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud
   * Interconnect*, the VLAN attachment must be created with this option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encryption;

  /**
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String interconnect;

  /**
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the
   * VLAN attachment that has the encryption option as IPSEC. The addresses must be regional
   * internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the
   * attachment is configured to use a regional internal IP address, then the VPN gateway's IP
   * address is allocated from the IP address range specified here. For example, if the HA VPN
   * gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address
   * for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN
   * attachment. If this field is not specified when creating the VLAN attachment, then later on
   * when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is
   * allocated from the regional external IP address pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ipsecInternalAddresses;

  /**
   * L2 Interconnect Attachment related config. This field is required if the type is L2_DEDICATED.
   * The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad) within L2 packets are
   * mapped to the destination appliances IP addresses. The packet is then encapsulated with the
   * appliance IP address and sent to the edge appliance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentL2Forwarding l2Forwarding;

  /**
   * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect
   * attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer mtu;

  /**
   * Whether or not to permit multicast traffic for this attachment. Multicast packets will be
   * dropped if this is not enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean multicastEnabled;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The
   * opaque identifier of a PARTNER attachment used to initiate provisioning with a selected
   * partner. Of the form "XXXXX/region/domain"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pairingKey;

  /**
   * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf
   * of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available
   * for DEDICATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long partnerAsn;

  /**
   * Informational metadata about Partner attachments from Partners to display to customers. Output
   * only for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentPartnerMetadata partnerMetadata;

  /**
   * The region that the Attachment is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region
   * as this InterconnectAttachment. The InterconnectAttachment will automatically connect the
   * Interconnect to the network & region within which the Cloud Router is configured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String router;

  /**
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled
   * or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect
   * attachments creation and update interconnect attachment operations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stackType;

  /**
   * Input only. Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default
   * value is 29, except for Cross-Cloud Interconnect connections that use an
   * InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example,
   * connections that use an Azure remote location fall into this category. In these cases, the
   * default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29
   * is preferred, because it gives Google Cloud Support more debugging visibility.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer subnetLength;

  /**
   * The type of interconnect attachment this is, which can take one of the following values: -
   * DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner
   * Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner
   * Interconnect, created by the partner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation
   * time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer vlanTag8021q;

  /**
   * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdminEnabled() {
    return adminEnabled;
  }

  /**
   * Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
   * @param adminEnabled adminEnabled or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setAdminEnabled(java.lang.Boolean adminEnabled) {
    this.adminEnabled = adminEnabled;
    return this;
  }

  /**
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type
   * DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner
   * that is operating the interconnect must set the bandwidth. Output only for PARTNER type,
   * mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: -
   * BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s -
   * BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5
   * Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
   * @return value or {@code null} for none
   */
  public java.lang.String getBandwidth() {
    return bandwidth;
  }

  /**
   * Provisioned bandwidth capacity for the interconnect attachment. For attachments of type
   * DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner
   * that is operating the interconnect must set the bandwidth. Output only for PARTNER type,
   * mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: -
   * BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s -
   * BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5
   * Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s - BPS_100G: 100 Gbit/s
   * @param bandwidth bandwidth or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setBandwidth(java.lang.String bandwidth) {
    this.bandwidth = bandwidth;
    return this;
  }

  /**
   * Single IPv4 address + prefix length to be configured on the cloud router interface for this
   * interconnect attachment. - Both candidate_cloud_router_ip_address and
   * candidate_customer_router_ip_address fields must be set or both must be unset. - Prefix length
   * of both candidate_cloud_router_ip_address and candidate_customer_router_ip_address must be the
   * same. - Max prefix length is 31.
   * @return value or {@code null} for none
   */
  public java.lang.String getCandidateCloudRouterIpAddress() {
    return candidateCloudRouterIpAddress;
  }

  /**
   * Single IPv4 address + prefix length to be configured on the cloud router interface for this
   * interconnect attachment. - Both candidate_cloud_router_ip_address and
   * candidate_customer_router_ip_address fields must be set or both must be unset. - Prefix length
   * of both candidate_cloud_router_ip_address and candidate_customer_router_ip_address must be the
   * same. - Max prefix length is 31.
   * @param candidateCloudRouterIpAddress candidateCloudRouterIpAddress or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setCandidateCloudRouterIpAddress(java.lang.String candidateCloudRouterIpAddress) {
    this.candidateCloudRouterIpAddress = candidateCloudRouterIpAddress;
    return this;
  }

  /**
   * Single IPv6 address + prefix length to be configured on the cloud router interface for this
   * interconnect attachment. - Both candidate_cloud_router_ipv6_address and
   * candidate_customer_router_ipv6_address fields must be set or both must be unset. - Prefix
   * length of both candidate_cloud_router_ipv6_address and candidate_customer_router_ipv6_address
   * must be the same. - Max prefix length is 126.
   * @return value or {@code null} for none
   */
  public java.lang.String getCandidateCloudRouterIpv6Address() {
    return candidateCloudRouterIpv6Address;
  }

  /**
   * Single IPv6 address + prefix length to be configured on the cloud router interface for this
   * interconnect attachment. - Both candidate_cloud_router_ipv6_address and
   * candidate_customer_router_ipv6_address fields must be set or both must be unset. - Prefix
   * length of both candidate_cloud_router_ipv6_address and candidate_customer_router_ipv6_address
   * must be the same. - Max prefix length is 126.
   * @param candidateCloudRouterIpv6Address candidateCloudRouterIpv6Address or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setCandidateCloudRouterIpv6Address(java.lang.String candidateCloudRouterIpv6Address) {
    this.candidateCloudRouterIpv6Address = candidateCloudRouterIpv6Address;
    return this;
  }

  /**
   * Single IPv4 address + prefix length to be configured on the customer router interface for this
   * interconnect attachment.
   * @return value or {@code null} for none
   */
  public java.lang.String getCandidateCustomerRouterIpAddress() {
    return candidateCustomerRouterIpAddress;
  }

  /**
   * Single IPv4 address + prefix length to be configured on the customer router interface for this
   * interconnect attachment.
   * @param candidateCustomerRouterIpAddress candidateCustomerRouterIpAddress or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setCandidateCustomerRouterIpAddress(java.lang.String candidateCustomerRouterIpAddress) {
    this.candidateCustomerRouterIpAddress = candidateCustomerRouterIpAddress;
    return this;
  }

  /**
   * Single IPv6 address + prefix length to be configured on the customer router interface for this
   * interconnect attachment.
   * @return value or {@code null} for none
   */
  public java.lang.String getCandidateCustomerRouterIpv6Address() {
    return candidateCustomerRouterIpv6Address;
  }

  /**
   * Single IPv6 address + prefix length to be configured on the customer router interface for this
   * interconnect attachment.
   * @param candidateCustomerRouterIpv6Address candidateCustomerRouterIpv6Address or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setCandidateCustomerRouterIpv6Address(java.lang.String candidateCustomerRouterIpv6Address) {
    this.candidateCustomerRouterIpv6Address = candidateCustomerRouterIpv6Address;
    return this;
  }

  /**
   * This field is not available.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCandidateIpv6Subnets() {
    return candidateIpv6Subnets;
  }

  /**
   * This field is not available.
   * @param candidateIpv6Subnets candidateIpv6Subnets or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setCandidateIpv6Subnets(java.util.List<java.lang.String> candidateIpv6Subnets) {
    this.candidateIpv6Subnets = candidateIpv6Subnets;
    return this;
  }

  /**
   * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of
   * cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be
   * within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc).
   * Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request
   * will fail if all possible /29s are in use on Google's edge. If not supplied, Google will
   * randomly select an unused /29 from all of link-local space.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCandidateSubnets() {
    return candidateSubnets;
  }

  /**
   * Input only. Up to 16 candidate prefixes that can be used to restrict the allocation of
   * cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be
   * within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc).
   * Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request
   * will fail if all possible /29s are in use on Google's edge. If not supplied, Google will
   * randomly select an unused /29 from all of link-local space.
   * @param candidateSubnets candidateSubnets or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setCandidateSubnets(java.util.List<java.lang.String> candidateSubnets) {
    this.candidateSubnets = candidateSubnets;
    return this;
  }

  /**
   * This field is not available.
   * @return value or {@code null} for none
   */
  public java.lang.String getCloudRouterIpv6InterfaceId() {
    return cloudRouterIpv6InterfaceId;
  }

  /**
   * This field is not available.
   * @param cloudRouterIpv6InterfaceId cloudRouterIpv6InterfaceId or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setCloudRouterIpv6InterfaceId(java.lang.String cloudRouterIpv6InterfaceId) {
    this.cloudRouterIpv6InterfaceId = cloudRouterIpv6InterfaceId;
    return this;
  }

  /**
   * This field is not available.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomerRouterIpv6InterfaceId() {
    return customerRouterIpv6InterfaceId;
  }

  /**
   * This field is not available.
   * @param customerRouterIpv6InterfaceId customerRouterIpv6InterfaceId or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setCustomerRouterIpv6InterfaceId(java.lang.String customerRouterIpv6InterfaceId) {
    this.customerRouterIpv6InterfaceId = customerRouterIpv6InterfaceId;
    return this;
  }

  /**
   * An optional description of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource.
   * @param description description or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Input only. Desired availability domain for the attachment. Only available for type PARTNER, at
   * creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY -
   * AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should
   * configure a pair of attachments, one per availability domain. The selected availability domain
   * will be provided to the Partner via the pairing key, so that the provisioned circuit will lie
   * in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * @return value or {@code null} for none
   */
  public java.lang.String getEdgeAvailabilityDomain() {
    return edgeAvailabilityDomain;
  }

  /**
   * Input only. Desired availability domain for the attachment. Only available for type PARTNER, at
   * creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY -
   * AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should
   * configure a pair of attachments, one per availability domain. The selected availability domain
   * will be provided to the Partner via the pairing key, so that the provisioned circuit will lie
   * in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
   * @param edgeAvailabilityDomain edgeAvailabilityDomain or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setEdgeAvailabilityDomain(java.lang.String edgeAvailabilityDomain) {
    this.edgeAvailabilityDomain = edgeAvailabilityDomain;
    return this;
  }

  /**
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment).
   * Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible
   * values are: - alpha - This is the default value, which means that the VLAN attachment carries
   * unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN
   * attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by
   * an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send
   * traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud
   * Interconnect*, the VLAN attachment must be created with this option.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncryption() {
    return encryption;
  }

  /**
   * Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment).
   * Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible
   * values are: - alpha - This is the default value, which means that the VLAN attachment carries
   * unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN
   * attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by
   * an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send
   * traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud
   * Interconnect*, the VLAN attachment must be created with this option.
   * @param encryption encryption or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setEncryption(java.lang.String encryption) {
    this.encryption = encryption;
    return this;
  }

  /**
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * @return value or {@code null} for none
   */
  public java.lang.String getInterconnect() {
    return interconnect;
  }

  /**
   * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
   * @param interconnect interconnect or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setInterconnect(java.lang.String interconnect) {
    this.interconnect = interconnect;
    return this;
  }

  /**
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the
   * VLAN attachment that has the encryption option as IPSEC. The addresses must be regional
   * internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the
   * attachment is configured to use a regional internal IP address, then the VPN gateway's IP
   * address is allocated from the IP address range specified here. For example, if the HA VPN
   * gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address
   * for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN
   * attachment. If this field is not specified when creating the VLAN attachment, then later on
   * when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is
   * allocated from the regional external IP address pool.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIpsecInternalAddresses() {
    return ipsecInternalAddresses;
  }

  /**
   * A list of URLs of addresses that have been reserved for the VLAN attachment. Used only for the
   * VLAN attachment that has the encryption option as IPSEC. The addresses must be regional
   * internal IP address ranges. When creating an HA VPN gateway over the VLAN attachment, if the
   * attachment is configured to use a regional internal IP address, then the VPN gateway's IP
   * address is allocated from the IP address range specified here. For example, if the HA VPN
   * gateway's interface 0 is paired to this VLAN attachment, then a regional internal IP address
   * for the VPN gateway interface 0 will be allocated from the IP address specified for this VLAN
   * attachment. If this field is not specified when creating the VLAN attachment, then later on
   * when creating an HA VPN gateway on this VLAN attachment, the HA VPN gateway's IP address is
   * allocated from the regional external IP address pool.
   * @param ipsecInternalAddresses ipsecInternalAddresses or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setIpsecInternalAddresses(java.util.List<java.lang.String> ipsecInternalAddresses) {
    this.ipsecInternalAddresses = ipsecInternalAddresses;
    return this;
  }

  /**
   * L2 Interconnect Attachment related config. This field is required if the type is L2_DEDICATED.
   * The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad) within L2 packets are
   * mapped to the destination appliances IP addresses. The packet is then encapsulated with the
   * appliance IP address and sent to the edge appliance.
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentL2Forwarding getL2Forwarding() {
    return l2Forwarding;
  }

  /**
   * L2 Interconnect Attachment related config. This field is required if the type is L2_DEDICATED.
   * The configuration specifies how VLAN tags (like dot1q, qinq, or dot1ad) within L2 packets are
   * mapped to the destination appliances IP addresses. The packet is then encapsulated with the
   * appliance IP address and sent to the edge appliance.
   * @param l2Forwarding l2Forwarding or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setL2Forwarding(InterconnectAttachmentL2Forwarding l2Forwarding) {
    this.l2Forwarding = l2Forwarding;
    return this;
  }

  /**
   * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect
   * attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMtu() {
    return mtu;
  }

  /**
   * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect
   * attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
   * @param mtu mtu or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setMtu(java.lang.Integer mtu) {
    this.mtu = mtu;
    return this;
  }

  /**
   * Whether or not to permit multicast traffic for this attachment. Multicast packets will be
   * dropped if this is not enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMulticastEnabled() {
    return multicastEnabled;
  }

  /**
   * Whether or not to permit multicast traffic for this attachment. Multicast packets will be
   * dropped if this is not enabled.
   * @param multicastEnabled multicastEnabled or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setMulticastEnabled(java.lang.Boolean multicastEnabled) {
    this.multicastEnabled = multicastEnabled;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The
   * opaque identifier of a PARTNER attachment used to initiate provisioning with a selected
   * partner. Of the form "XXXXX/region/domain"
   * @return value or {@code null} for none
   */
  public java.lang.String getPairingKey() {
    return pairingKey;
  }

  /**
   * [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The
   * opaque identifier of a PARTNER attachment used to initiate provisioning with a selected
   * partner. Of the form "XXXXX/region/domain"
   * @param pairingKey pairingKey or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setPairingKey(java.lang.String pairingKey) {
    this.pairingKey = pairingKey;
    return this;
  }

  /**
   * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf
   * of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available
   * for DEDICATED.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPartnerAsn() {
    return partnerAsn;
  }

  /**
   * Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf
   * of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available
   * for DEDICATED.
   * @param partnerAsn partnerAsn or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setPartnerAsn(java.lang.Long partnerAsn) {
    this.partnerAsn = partnerAsn;
    return this;
  }

  /**
   * Informational metadata about Partner attachments from Partners to display to customers. Output
   * only for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentPartnerMetadata getPartnerMetadata() {
    return partnerMetadata;
  }

  /**
   * Informational metadata about Partner attachments from Partners to display to customers. Output
   * only for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
   * @param partnerMetadata partnerMetadata or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setPartnerMetadata(InterconnectAttachmentPartnerMetadata partnerMetadata) {
    this.partnerMetadata = partnerMetadata;
    return this;
  }

  /**
   * The region that the Attachment is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * The region that the Attachment is in.
   * @param region region or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region
   * as this InterconnectAttachment. The InterconnectAttachment will automatically connect the
   * Interconnect to the network & region within which the Cloud Router is configured.
   * @return value or {@code null} for none
   */
  public java.lang.String getRouter() {
    return router;
  }

  /**
   * URL of the Cloud Router to be used for dynamic routing. This router must be in the same region
   * as this InterconnectAttachment. The InterconnectAttachment will automatically connect the
   * Interconnect to the network & region within which the Cloud Router is configured.
   * @param router router or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setRouter(java.lang.String router) {
    this.router = router;
    return this;
  }

  /**
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled
   * or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect
   * attachments creation and update interconnect attachment operations.
   * @return value or {@code null} for none
   */
  public java.lang.String getStackType() {
    return stackType;
  }

  /**
   * The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled
   * or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect
   * attachments creation and update interconnect attachment operations.
   * @param stackType stackType or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setStackType(java.lang.String stackType) {
    this.stackType = stackType;
    return this;
  }

  /**
   * Input only. Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default
   * value is 29, except for Cross-Cloud Interconnect connections that use an
   * InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example,
   * connections that use an Azure remote location fall into this category. In these cases, the
   * default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29
   * is preferred, because it gives Google Cloud Support more debugging visibility.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSubnetLength() {
    return subnetLength;
  }

  /**
   * Input only. Length of the IPv4 subnet mask. Allowed values: - 29 (default) - 30 The default
   * value is 29, except for Cross-Cloud Interconnect connections that use an
   * InterconnectRemoteLocation with a constraints.subnetLengthRange.min equal to 30. For example,
   * connections that use an Azure remote location fall into this category. In these cases, the
   * default value is 30, and requesting 29 returns an error. Where both 29 and 30 are allowed, 29
   * is preferred, because it gives Google Cloud Support more debugging visibility.
   * @param subnetLength subnetLength or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setSubnetLength(java.lang.Integer subnetLength) {
    this.subnetLength = subnetLength;
    return this;
  }

  /**
   * The type of interconnect attachment this is, which can take one of the following values: -
   * DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner
   * Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner
   * Interconnect, created by the partner.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of interconnect attachment this is, which can take one of the following values: -
   * DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner
   * Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner
   * Interconnect, created by the partner.
   * @param type type or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation
   * time.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVlanTag8021q() {
    return vlanTag8021q;
  }

  /**
   * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4093. Only specified at creation
   * time.
   * @param vlanTag8021q vlanTag8021q or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput setVlanTag8021q(java.lang.Integer vlanTag8021q) {
    this.vlanTag8021q = vlanTag8021q;
    return this;
  }

  @Override
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput set(String fieldName, Object value) {
    return (InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput clone() {
    return (InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput) super.clone();
  }

}
