/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An interconnect group resource allows customers to create, analyze, and expand their redundant
 * connections.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectGroup extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectGroupConfigured configured;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Opaque system-generated token that uniquely identifies the configuration. If provided when
   * patching a configuration in update mode, the provided token must match the current token or the
   * update is rejected. This provides a reliable means of doing read-modify-write (optimistic
   * locking) as described by API 154.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectGroupIntent intent;

  /**
   * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are
   * encouraged, but not required, to use their preferred format for resource links as keys. Note
   * that there are add-members and remove-members methods in gcloud. The size of this map is
   * limited by an "Interconnects per group" quota.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, InterconnectGroupInterconnect> interconnects;

  /**
   * [Output Only] Type of the resource. Always compute#InterconnectGroup
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectGroupPhysicalStructure physicalStructure;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * @return value or {@code null} for none
   */
  public InterconnectGroupConfigured getConfigured() {
    return configured;
  }

  /**
   * @param configured configured or {@code null} for none
   */
  public InterconnectGroup setConfigured(InterconnectGroupConfigured configured) {
    this.configured = configured;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public InterconnectGroup setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public InterconnectGroup setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Opaque system-generated token that uniquely identifies the configuration. If provided when
   * patching a configuration in update mode, the provided token must match the current token or the
   * update is rejected. This provides a reliable means of doing read-modify-write (optimistic
   * locking) as described by API 154.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Opaque system-generated token that uniquely identifies the configuration. If provided when
   * patching a configuration in update mode, the provided token must match the current token or the
   * update is rejected. This provides a reliable means of doing read-modify-write (optimistic
   * locking) as described by API 154.
   * @param etag etag or {@code null} for none
   */
  public InterconnectGroup setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @param id id or {@code null} for none
   */
  public InterconnectGroup setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public InterconnectGroupIntent getIntent() {
    return intent;
  }

  /**
   * @param intent intent or {@code null} for none
   */
  public InterconnectGroup setIntent(InterconnectGroupIntent intent) {
    this.intent = intent;
    return this;
  }

  /**
   * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are
   * encouraged, but not required, to use their preferred format for resource links as keys. Note
   * that there are add-members and remove-members methods in gcloud. The size of this map is
   * limited by an "Interconnects per group" quota.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, InterconnectGroupInterconnect> getInterconnects() {
    return interconnects;
  }

  /**
   * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are
   * encouraged, but not required, to use their preferred format for resource links as keys. Note
   * that there are add-members and remove-members methods in gcloud. The size of this map is
   * limited by an "Interconnects per group" quota.
   * @param interconnects interconnects or {@code null} for none
   */
  public InterconnectGroup setInterconnects(java.util.Map<String, InterconnectGroupInterconnect> interconnects) {
    this.interconnects = interconnects;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#InterconnectGroup
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#InterconnectGroup
   * @param kind kind or {@code null} for none
   */
  public InterconnectGroup setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public InterconnectGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public InterconnectGroupPhysicalStructure getPhysicalStructure() {
    return physicalStructure;
  }

  /**
   * @param physicalStructure physicalStructure or {@code null} for none
   */
  public InterconnectGroup setPhysicalStructure(InterconnectGroupPhysicalStructure physicalStructure) {
    this.physicalStructure = physicalStructure;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public InterconnectGroup setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public InterconnectGroup set(String fieldName, Object value) {
    return (InterconnectGroup) super.set(fieldName, value);
  }

  @Override
  public InterconnectGroup clone() {
    return (InterconnectGroup) super.clone();
  }

}
