/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Request to get the status of the interconnect group with extra detail.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectGroupsOperationalStatus extends com.google.api.client.json.GenericJson {

  /**
   * The configuration analysis, as returned by Get.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectGroupConfigured configured;

  /**
   * Summarizes the status of the group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String groupStatus;

  /**
   * The intent of the resource, as returned by Get.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectGroupIntent intent;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectGroupsOperationalStatusInterconnectStatus> interconnectStatuses;

  /**
   * The operational state of the group, including only active Interconnects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectGroupConfigured operational;

  /**
   * The configuration analysis, as returned by Get.
   * @return value or {@code null} for none
   */
  public InterconnectGroupConfigured getConfigured() {
    return configured;
  }

  /**
   * The configuration analysis, as returned by Get.
   * @param configured configured or {@code null} for none
   */
  public InterconnectGroupsOperationalStatus setConfigured(InterconnectGroupConfigured configured) {
    this.configured = configured;
    return this;
  }

  /**
   * Summarizes the status of the group.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroupStatus() {
    return groupStatus;
  }

  /**
   * Summarizes the status of the group.
   * @param groupStatus groupStatus or {@code null} for none
   */
  public InterconnectGroupsOperationalStatus setGroupStatus(java.lang.String groupStatus) {
    this.groupStatus = groupStatus;
    return this;
  }

  /**
   * The intent of the resource, as returned by Get.
   * @return value or {@code null} for none
   */
  public InterconnectGroupIntent getIntent() {
    return intent;
  }

  /**
   * The intent of the resource, as returned by Get.
   * @param intent intent or {@code null} for none
   */
  public InterconnectGroupsOperationalStatus setIntent(InterconnectGroupIntent intent) {
    this.intent = intent;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectGroupsOperationalStatusInterconnectStatus> getInterconnectStatuses() {
    return interconnectStatuses;
  }

  /**
   * @param interconnectStatuses interconnectStatuses or {@code null} for none
   */
  public InterconnectGroupsOperationalStatus setInterconnectStatuses(java.util.List<InterconnectGroupsOperationalStatusInterconnectStatus> interconnectStatuses) {
    this.interconnectStatuses = interconnectStatuses;
    return this;
  }

  /**
   * The operational state of the group, including only active Interconnects.
   * @return value or {@code null} for none
   */
  public InterconnectGroupConfigured getOperational() {
    return operational;
  }

  /**
   * The operational state of the group, including only active Interconnects.
   * @param operational operational or {@code null} for none
   */
  public InterconnectGroupsOperationalStatus setOperational(InterconnectGroupConfigured operational) {
    this.operational = operational;
    return this;
  }

  @Override
  public InterconnectGroupsOperationalStatus set(String fieldName, Object value) {
    return (InterconnectGroupsOperationalStatus) super.set(fieldName, value);
  }

  @Override
  public InterconnectGroupsOperationalStatus clone() {
    return (InterconnectGroupsOperationalStatus) super.clone();
  }

}
