/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Multi-MIG member resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MultiMigMember extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp of this multi-MIG member in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output only] The unique identifier for this resource type. The server generates this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource. Always compute#multiMigMember for a list of multi-MIG members.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] The name of this multi-MIG member generated by Google Compute Engine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The URL of the region where the multi-MIG resides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * [Output Only] The status of this multi-MIG member
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MultiMigMemberStatus status;

  /**
   * [Output Only] Creation timestamp of this multi-MIG member in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp of this multi-MIG member in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public MultiMigMember setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource.
   * @param description description or {@code null} for none
   */
  public MultiMigMember setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output only] The unique identifier for this resource type. The server generates this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output only] The unique identifier for this resource type. The server generates this
   * identifier.
   * @param id id or {@code null} for none
   */
  public MultiMigMember setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource. Always compute#multiMigMember for a list of multi-MIG members.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource. Always compute#multiMigMember for a list of multi-MIG members.
   * @param kind kind or {@code null} for none
   */
  public MultiMigMember setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] The name of this multi-MIG member generated by Google Compute Engine.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] The name of this multi-MIG member generated by Google Compute Engine.
   * @param name name or {@code null} for none
   */
  public MultiMigMember setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The URL of the region where the multi-MIG resides.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] The URL of the region where the multi-MIG resides.
   * @param region region or {@code null} for none
   */
  public MultiMigMember setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public MultiMigMember setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public MultiMigMember setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * [Output Only] The status of this multi-MIG member
   * @return value or {@code null} for none
   */
  public MultiMigMemberStatus getStatus() {
    return status;
  }

  /**
   * [Output Only] The status of this multi-MIG member
   * @param status status or {@code null} for none
   */
  public MultiMigMember setStatus(MultiMigMemberStatus status) {
    this.status = status;
    return this;
  }

  @Override
  public MultiMigMember set(String fieldName, Object value) {
    return (MultiMigMember) super.set(fieldName, value);
  }

  @Override
  public MultiMigMember clone() {
    return (MultiMigMember) super.clone();
  }

}
