/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a reservation block resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReservationBlock extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The number of resources that are allocated in this reservation block.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer count;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] The number of instances that are currently in use on this reservation block.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer inUseCount;

  /**
   * [Output Only] Type of the resource. Always compute#reservationBlock for reservation blocks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] Obfuscated location where this reservation block physically resides in format
   * /CCCC/GGGG. This matches the tripod specified in the VM topology information. Example:
   * /USEAB1/0101/ is the location prefix in /USEAB1/0101/031/003
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationPrefix;

  /**
   * [Output Only] The name of this reservation block generated by Google Compute Engine. The name
   * must be 1-63 characters long, and comply with RFC1035 @pattern
   * [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The physical topology of the reservation block.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReservationBlockPhysicalTopology physicalTopology;

  /**
   * [Output Only] Maintenance information for this reservation block.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GroupMaintenanceInfo reservationMaintenance;

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * [Output Only] Status of the reservation block.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * [Output Only] Zone in which the reservation block resides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * [Output Only] The number of resources that are allocated in this reservation block.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCount() {
    return count;
  }

  /**
   * [Output Only] The number of resources that are allocated in this reservation block.
   * @param count count or {@code null} for none
   */
  public ReservationBlock setCount(java.lang.Integer count) {
    this.count = count;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public ReservationBlock setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public ReservationBlock setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] The number of instances that are currently in use on this reservation block.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInUseCount() {
    return inUseCount;
  }

  /**
   * [Output Only] The number of instances that are currently in use on this reservation block.
   * @param inUseCount inUseCount or {@code null} for none
   */
  public ReservationBlock setInUseCount(java.lang.Integer inUseCount) {
    this.inUseCount = inUseCount;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#reservationBlock for reservation blocks.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#reservationBlock for reservation blocks.
   * @param kind kind or {@code null} for none
   */
  public ReservationBlock setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] Obfuscated location where this reservation block physically resides in format
   * /CCCC/GGGG. This matches the tripod specified in the VM topology information. Example:
   * /USEAB1/0101/ is the location prefix in /USEAB1/0101/031/003
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationPrefix() {
    return locationPrefix;
  }

  /**
   * [Output Only] Obfuscated location where this reservation block physically resides in format
   * /CCCC/GGGG. This matches the tripod specified in the VM topology information. Example:
   * /USEAB1/0101/ is the location prefix in /USEAB1/0101/031/003
   * @param locationPrefix locationPrefix or {@code null} for none
   */
  public ReservationBlock setLocationPrefix(java.lang.String locationPrefix) {
    this.locationPrefix = locationPrefix;
    return this;
  }

  /**
   * [Output Only] The name of this reservation block generated by Google Compute Engine. The name
   * must be 1-63 characters long, and comply with RFC1035 @pattern
   * [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] The name of this reservation block generated by Google Compute Engine. The name
   * must be 1-63 characters long, and comply with RFC1035 @pattern
   * [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?
   * @param name name or {@code null} for none
   */
  public ReservationBlock setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The physical topology of the reservation block.
   * @return value or {@code null} for none
   */
  public ReservationBlockPhysicalTopology getPhysicalTopology() {
    return physicalTopology;
  }

  /**
   * [Output Only] The physical topology of the reservation block.
   * @param physicalTopology physicalTopology or {@code null} for none
   */
  public ReservationBlock setPhysicalTopology(ReservationBlockPhysicalTopology physicalTopology) {
    this.physicalTopology = physicalTopology;
    return this;
  }

  /**
   * [Output Only] Maintenance information for this reservation block.
   * @return value or {@code null} for none
   */
  public GroupMaintenanceInfo getReservationMaintenance() {
    return reservationMaintenance;
  }

  /**
   * [Output Only] Maintenance information for this reservation block.
   * @param reservationMaintenance reservationMaintenance or {@code null} for none
   */
  public ReservationBlock setReservationMaintenance(GroupMaintenanceInfo reservationMaintenance) {
    this.reservationMaintenance = reservationMaintenance;
    return this;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public ReservationBlock setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public ReservationBlock setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * [Output Only] Status of the reservation block.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] Status of the reservation block.
   * @param status status or {@code null} for none
   */
  public ReservationBlock setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * [Output Only] Zone in which the reservation block resides.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] Zone in which the reservation block resides.
   * @param zone zone or {@code null} for none
   */
  public ReservationBlock setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public ReservationBlock set(String fieldName, Object value) {
    return (ReservationBlock) super.set(fieldName, value);
  }

  @Override
  public ReservationBlock clone() {
    return (ReservationBlock) super.clone();
  }

}
