/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Effective values of predefined metadata keys for an instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceStatusEffectiveInstanceMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Effective enable-oslogin value at Instance level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableOsloginMetadataValue;

  /**
   * Effective VM DNS setting at Instance level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmDnsSettingMetadataValue;

  /**
   * Effective enable-oslogin value at Instance level.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableOsloginMetadataValue() {
    return enableOsloginMetadataValue;
  }

  /**
   * Effective enable-oslogin value at Instance level.
   * @param enableOsloginMetadataValue enableOsloginMetadataValue or {@code null} for none
   */
  public ResourceStatusEffectiveInstanceMetadata setEnableOsloginMetadataValue(java.lang.Boolean enableOsloginMetadataValue) {
    this.enableOsloginMetadataValue = enableOsloginMetadataValue;
    return this;
  }

  /**
   * Effective VM DNS setting at Instance level.
   * @return value or {@code null} for none
   */
  public java.lang.String getVmDnsSettingMetadataValue() {
    return vmDnsSettingMetadataValue;
  }

  /**
   * Effective VM DNS setting at Instance level.
   * @param vmDnsSettingMetadataValue vmDnsSettingMetadataValue or {@code null} for none
   */
  public ResourceStatusEffectiveInstanceMetadata setVmDnsSettingMetadataValue(java.lang.String vmDnsSettingMetadataValue) {
    this.vmDnsSettingMetadataValue = vmDnsSettingMetadataValue;
    return this;
  }

  @Override
  public ResourceStatusEffectiveInstanceMetadata set(String fieldName, Object value) {
    return (ResourceStatusEffectiveInstanceMetadata) super.set(fieldName, value);
  }

  @Override
  public ResourceStatusEffectiveInstanceMetadata clone() {
    return (ResourceStatusEffectiveInstanceMetadata) super.clone();
  }

}
