/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Recommendation with reference url.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RiskRecommendation extends com.google.api.client.json.GenericJson {

  /**
   * Mitigation guide for the risk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * URL referencing a more detailed mitigation guide.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String referenceUrl;

  /**
   * Mitigation guide for the risk.
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * Mitigation guide for the risk.
   * @param content content or {@code null} for none
   */
  public RiskRecommendation setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * URL referencing a more detailed mitigation guide.
   * @return value or {@code null} for none
   */
  public java.lang.String getReferenceUrl() {
    return referenceUrl;
  }

  /**
   * URL referencing a more detailed mitigation guide.
   * @param referenceUrl referenceUrl or {@code null} for none
   */
  public RiskRecommendation setReferenceUrl(java.lang.String referenceUrl) {
    this.referenceUrl = referenceUrl;
    return this;
  }

  @Override
  public RiskRecommendation set(String fieldName, Object value) {
    return (RiskRecommendation) super.set(fieldName, value);
  }

  @Override
  public RiskRecommendation clone() {
    return (RiskRecommendation) super.clone();
  }

}
