/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Service level details determined for the wire group configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WireGroupServiceLevel extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The availability SLA that the wire group qualifies for. One of the following:
   * `NO_AVAILABILITY_SLA`, `AVAILABILITY_99`, `AVAILABILITY_999`, or `AVAILABILITY_9995`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String availabilityClass;

  /**
   * [Output Only] The availability SLA that the wire group qualifies for. One of the following:
   * `NO_AVAILABILITY_SLA`, `AVAILABILITY_99`, `AVAILABILITY_999`, or `AVAILABILITY_9995`.
   * @return value or {@code null} for none
   */
  public java.lang.String getAvailabilityClass() {
    return availabilityClass;
  }

  /**
   * [Output Only] The availability SLA that the wire group qualifies for. One of the following:
   * `NO_AVAILABILITY_SLA`, `AVAILABILITY_99`, `AVAILABILITY_999`, or `AVAILABILITY_9995`.
   * @param availabilityClass availabilityClass or {@code null} for none
   */
  public WireGroupServiceLevel setAvailabilityClass(java.lang.String availabilityClass) {
    this.availabilityClass = availabilityClass;
    return this;
  }

  @Override
  public WireGroupServiceLevel set(String fieldName, Object value) {
    return (WireGroupServiceLevel) super.set(fieldName, value);
  }

  @Override
  public WireGroupServiceLevel clone() {
    return (WireGroupServiceLevel) super.clone();
  }

}
