/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Topology details for a single wire group endpoint.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WireGroupTopologyEndpoint extends com.google.api.client.json.GenericJson {

  /**
   * The InterconnectLocation.city (metropolitan area designator) that all interconnects are located
   * in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String city;

  /**
   * Endpoint label from the wire group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * The InterconnectLocation.city (metropolitan area designator) that all interconnects are located
   * in.
   * @return value or {@code null} for none
   */
  public java.lang.String getCity() {
    return city;
  }

  /**
   * The InterconnectLocation.city (metropolitan area designator) that all interconnects are located
   * in.
   * @param city city or {@code null} for none
   */
  public WireGroupTopologyEndpoint setCity(java.lang.String city) {
    this.city = city;
    return this;
  }

  /**
   * Endpoint label from the wire group.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * Endpoint label from the wire group.
   * @param label label or {@code null} for none
   */
  public WireGroupTopologyEndpoint setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  @Override
  public WireGroupTopologyEndpoint set(String fieldName, Object value) {
    return (WireGroupTopologyEndpoint) super.set(fieldName, value);
  }

  @Override
  public WireGroupTopologyEndpoint clone() {
    return (WireGroupTopologyEndpoint) super.clone();
  }

}
