/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Custom Metrics are used for CUSTOM_METRICS balancing_mode.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendCustomMetric extends com.google.api.client.json.GenericJson {

  /**
   * If true, the metric data is collected and reported to Cloud Monitoring, but is not used for
   * load balancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dryRun;

  /**
   * Optional parameter to define a target utilization for the Custom Metrics balancing mode. The
   * valid range is [0.0, 1.0].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxUtilization;

  /**
   * Name of a custom utilization signal. The name must be 1-64 characters long and match the
   * regular expression [a-z]([-_.a-z0-9]*[a-z0-9])? which means the first character must be a
   * lowercase letter, and all following characters must be a dash, period, underscore, lowercase
   * letter, or digit, except the last character, which cannot be a dash, period, or underscore. For
   * usage guidelines, see Custom Metrics balancing mode. This field can only be used for a global
   * or regional backend service with the loadBalancingScheme set to EXTERNAL_MANAGED,
   * INTERNAL_MANAGED INTERNAL_SELF_MANAGED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * If true, the metric data is collected and reported to Cloud Monitoring, but is not used for
   * load balancing.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDryRun() {
    return dryRun;
  }

  /**
   * If true, the metric data is collected and reported to Cloud Monitoring, but is not used for
   * load balancing.
   * @param dryRun dryRun or {@code null} for none
   */
  public BackendCustomMetric setDryRun(java.lang.Boolean dryRun) {
    this.dryRun = dryRun;
    return this;
  }

  /**
   * Optional parameter to define a target utilization for the Custom Metrics balancing mode. The
   * valid range is [0.0, 1.0].
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxUtilization() {
    return maxUtilization;
  }

  /**
   * Optional parameter to define a target utilization for the Custom Metrics balancing mode. The
   * valid range is [0.0, 1.0].
   * @param maxUtilization maxUtilization or {@code null} for none
   */
  public BackendCustomMetric setMaxUtilization(java.lang.Float maxUtilization) {
    this.maxUtilization = maxUtilization;
    return this;
  }

  /**
   * Name of a custom utilization signal. The name must be 1-64 characters long and match the
   * regular expression [a-z]([-_.a-z0-9]*[a-z0-9])? which means the first character must be a
   * lowercase letter, and all following characters must be a dash, period, underscore, lowercase
   * letter, or digit, except the last character, which cannot be a dash, period, or underscore. For
   * usage guidelines, see Custom Metrics balancing mode. This field can only be used for a global
   * or regional backend service with the loadBalancingScheme set to EXTERNAL_MANAGED,
   * INTERNAL_MANAGED INTERNAL_SELF_MANAGED.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of a custom utilization signal. The name must be 1-64 characters long and match the
   * regular expression [a-z]([-_.a-z0-9]*[a-z0-9])? which means the first character must be a
   * lowercase letter, and all following characters must be a dash, period, underscore, lowercase
   * letter, or digit, except the last character, which cannot be a dash, period, or underscore. For
   * usage guidelines, see Custom Metrics balancing mode. This field can only be used for a global
   * or regional backend service with the loadBalancingScheme set to EXTERNAL_MANAGED,
   * INTERNAL_MANAGED INTERNAL_SELF_MANAGED.
   * @param name name or {@code null} for none
   */
  public BackendCustomMetric setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public BackendCustomMetric set(String fieldName, Object value) {
    return (BackendCustomMetric) super.set(fieldName, value);
  }

  @Override
  public BackendCustomMetric clone() {
    return (BackendCustomMetric) super.clone();
  }

}
