/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for BackendServiceHAPolicyLeader.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceHAPolicyLeader extends com.google.api.client.json.GenericJson {

  /**
   * A fully-qualified URL (starting with https://www.googleapis.com/) of the zonal Network Endpoint
   * Group (NEG) with `GCE_VM_IP` endpoints that the leader is attached to. The leader's
   * backendGroup must already be specified as a backend of this backend service. Removing a backend
   * that is designated as the leader's backendGroup is not permitted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backendGroup;

  /**
   * The network endpoint within the leader.backendGroup that is designated as the leader. This
   * network endpoint cannot be detached from the NEG specified in the haPolicy.leader.backendGroup
   * until the leader is updated with another network endpoint, or the leader is removed from the
   * haPolicy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BackendServiceHAPolicyLeaderNetworkEndpoint networkEndpoint;

  /**
   * A fully-qualified URL (starting with https://www.googleapis.com/) of the zonal Network Endpoint
   * Group (NEG) with `GCE_VM_IP` endpoints that the leader is attached to. The leader's
   * backendGroup must already be specified as a backend of this backend service. Removing a backend
   * that is designated as the leader's backendGroup is not permitted.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackendGroup() {
    return backendGroup;
  }

  /**
   * A fully-qualified URL (starting with https://www.googleapis.com/) of the zonal Network Endpoint
   * Group (NEG) with `GCE_VM_IP` endpoints that the leader is attached to. The leader's
   * backendGroup must already be specified as a backend of this backend service. Removing a backend
   * that is designated as the leader's backendGroup is not permitted.
   * @param backendGroup backendGroup or {@code null} for none
   */
  public BackendServiceHAPolicyLeader setBackendGroup(java.lang.String backendGroup) {
    this.backendGroup = backendGroup;
    return this;
  }

  /**
   * The network endpoint within the leader.backendGroup that is designated as the leader. This
   * network endpoint cannot be detached from the NEG specified in the haPolicy.leader.backendGroup
   * until the leader is updated with another network endpoint, or the leader is removed from the
   * haPolicy.
   * @return value or {@code null} for none
   */
  public BackendServiceHAPolicyLeaderNetworkEndpoint getNetworkEndpoint() {
    return networkEndpoint;
  }

  /**
   * The network endpoint within the leader.backendGroup that is designated as the leader. This
   * network endpoint cannot be detached from the NEG specified in the haPolicy.leader.backendGroup
   * until the leader is updated with another network endpoint, or the leader is removed from the
   * haPolicy.
   * @param networkEndpoint networkEndpoint or {@code null} for none
   */
  public BackendServiceHAPolicyLeader setNetworkEndpoint(BackendServiceHAPolicyLeaderNetworkEndpoint networkEndpoint) {
    this.networkEndpoint = networkEndpoint;
    return this;
  }

  @Override
  public BackendServiceHAPolicyLeader set(String fieldName, Object value) {
    return (BackendServiceHAPolicyLeader) super.set(fieldName, value);
  }

  @Override
  public BackendServiceHAPolicyLeader clone() {
    return (BackendServiceHAPolicyLeader) super.clone();
  }

}
