/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity extends com.google.api.client.json.GenericJson {

  /**
   * This field indicates whether zonal affinity is enabled or not. The possible values are: -
   * ZONAL_AFFINITY_DISABLED: Default Value. Zonal Affinity is disabled. The load balancer
   * distributes new connections to all healthy backend endpoints across all zones. -
   * ZONAL_AFFINITY_STAY_WITHIN_ZONE: Zonal Affinity is enabled. The load balancer distributes new
   * connections to all healthy backend endpoints in the local zone only. If there are no healthy
   * backend endpoints in the local zone, the load balancer distributes new connections to all
   * backend endpoints in the local zone. - ZONAL_AFFINITY_SPILL_CROSS_ZONE: Zonal Affinity is
   * enabled. The load balancer distributes new connections to all healthy backend endpoints in the
   * local zone only. If there aren't enough healthy backend endpoints in the local zone, the load
   * balancer distributes new connections to all healthy backend endpoints across all zones.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spillover;

  /**
   * The value of the field must be in [0, 1]. When the ratio of the count of healthy backend
   * endpoints in a zone to the count of backend endpoints in that same zone is equal to or above
   * this threshold, the load balancer distributes new connections to all healthy endpoints in the
   * local zone only. When the ratio of the count of healthy backend endpoints in a zone to the
   * count of backend endpoints in that same zone is below this threshold, the load balancer
   * distributes all new connections to all healthy endpoints across all zones.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float spilloverRatio;

  /**
   * This field indicates whether zonal affinity is enabled or not. The possible values are: -
   * ZONAL_AFFINITY_DISABLED: Default Value. Zonal Affinity is disabled. The load balancer
   * distributes new connections to all healthy backend endpoints across all zones. -
   * ZONAL_AFFINITY_STAY_WITHIN_ZONE: Zonal Affinity is enabled. The load balancer distributes new
   * connections to all healthy backend endpoints in the local zone only. If there are no healthy
   * backend endpoints in the local zone, the load balancer distributes new connections to all
   * backend endpoints in the local zone. - ZONAL_AFFINITY_SPILL_CROSS_ZONE: Zonal Affinity is
   * enabled. The load balancer distributes new connections to all healthy backend endpoints in the
   * local zone only. If there aren't enough healthy backend endpoints in the local zone, the load
   * balancer distributes new connections to all healthy backend endpoints across all zones.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpillover() {
    return spillover;
  }

  /**
   * This field indicates whether zonal affinity is enabled or not. The possible values are: -
   * ZONAL_AFFINITY_DISABLED: Default Value. Zonal Affinity is disabled. The load balancer
   * distributes new connections to all healthy backend endpoints across all zones. -
   * ZONAL_AFFINITY_STAY_WITHIN_ZONE: Zonal Affinity is enabled. The load balancer distributes new
   * connections to all healthy backend endpoints in the local zone only. If there are no healthy
   * backend endpoints in the local zone, the load balancer distributes new connections to all
   * backend endpoints in the local zone. - ZONAL_AFFINITY_SPILL_CROSS_ZONE: Zonal Affinity is
   * enabled. The load balancer distributes new connections to all healthy backend endpoints in the
   * local zone only. If there aren't enough healthy backend endpoints in the local zone, the load
   * balancer distributes new connections to all healthy backend endpoints across all zones.
   * @param spillover spillover or {@code null} for none
   */
  public BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity setSpillover(java.lang.String spillover) {
    this.spillover = spillover;
    return this;
  }

  /**
   * The value of the field must be in [0, 1]. When the ratio of the count of healthy backend
   * endpoints in a zone to the count of backend endpoints in that same zone is equal to or above
   * this threshold, the load balancer distributes new connections to all healthy endpoints in the
   * local zone only. When the ratio of the count of healthy backend endpoints in a zone to the
   * count of backend endpoints in that same zone is below this threshold, the load balancer
   * distributes all new connections to all healthy endpoints across all zones.
   * @return value or {@code null} for none
   */
  public java.lang.Float getSpilloverRatio() {
    return spilloverRatio;
  }

  /**
   * The value of the field must be in [0, 1]. When the ratio of the count of healthy backend
   * endpoints in a zone to the count of backend endpoints in that same zone is equal to or above
   * this threshold, the load balancer distributes new connections to all healthy endpoints in the
   * local zone only. When the ratio of the count of healthy backend endpoints in a zone to the
   * count of backend endpoints in that same zone is below this threshold, the load balancer
   * distributes all new connections to all healthy endpoints across all zones.
   * @param spilloverRatio spilloverRatio or {@code null} for none
   */
  public BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity setSpilloverRatio(java.lang.Float spilloverRatio) {
    this.spilloverRatio = spilloverRatio;
    return this;
  }

  @Override
  public BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity set(String fieldName, Object value) {
    return (BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity) super.set(fieldName, value);
  }

  @Override
  public BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity clone() {
    return (BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity) super.clone();
  }

}
