/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for DiskPairReplicationState.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiskPairReplicationState extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The status of disk creation. - ASYNC_REPLICATION_STATE_INITIALIZING: The device
   * is doing the initial replication after starting the replication. -
   * ASYNC_REPLICATION_STATE_REPLICATING_HEALTHY: The primary disk is healthily replicating to the
   * secondary device i.e. last_replication_time is within RPO. -
   * ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_HIGH_CHURN: The replication is lagging above the SLO
   * limit due to the disk's change rate being above the supported limit. -
   * ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_SYSTEM_LAGGING: The replication is lagging, and the
   * RPO is not being met due to some internal issue. - ASYNC_REPLICATION_STATE_REPLICATION_STUCK:
   * The replication is completely stuck due to some internal error. -
   * ASYNC_REPLICATION_STATE_STOPPING: The replication is under the process of being stopped. This
   * is a transient state. - ASYNC_REPLICATION_STATE_STOPPED: The replication between the disk-pairs
   * have stopped. - ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_CG_HIGH_CHURN: The replication is
   * lagging above the SLO limit for the disk in the consistency group due to disk's change rate
   * being above the supported limit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataReplicationState;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplicationDiskPair replicationDiskPair;

  /**
   * [Output Only] The status of disk creation. - ASYNC_REPLICATION_STATE_INITIALIZING: The device
   * is doing the initial replication after starting the replication. -
   * ASYNC_REPLICATION_STATE_REPLICATING_HEALTHY: The primary disk is healthily replicating to the
   * secondary device i.e. last_replication_time is within RPO. -
   * ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_HIGH_CHURN: The replication is lagging above the SLO
   * limit due to the disk's change rate being above the supported limit. -
   * ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_SYSTEM_LAGGING: The replication is lagging, and the
   * RPO is not being met due to some internal issue. - ASYNC_REPLICATION_STATE_REPLICATION_STUCK:
   * The replication is completely stuck due to some internal error. -
   * ASYNC_REPLICATION_STATE_STOPPING: The replication is under the process of being stopped. This
   * is a transient state. - ASYNC_REPLICATION_STATE_STOPPED: The replication between the disk-pairs
   * have stopped. - ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_CG_HIGH_CHURN: The replication is
   * lagging above the SLO limit for the disk in the consistency group due to disk's change rate
   * being above the supported limit.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataReplicationState() {
    return dataReplicationState;
  }

  /**
   * [Output Only] The status of disk creation. - ASYNC_REPLICATION_STATE_INITIALIZING: The device
   * is doing the initial replication after starting the replication. -
   * ASYNC_REPLICATION_STATE_REPLICATING_HEALTHY: The primary disk is healthily replicating to the
   * secondary device i.e. last_replication_time is within RPO. -
   * ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_HIGH_CHURN: The replication is lagging above the SLO
   * limit due to the disk's change rate being above the supported limit. -
   * ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_SYSTEM_LAGGING: The replication is lagging, and the
   * RPO is not being met due to some internal issue. - ASYNC_REPLICATION_STATE_REPLICATION_STUCK:
   * The replication is completely stuck due to some internal error. -
   * ASYNC_REPLICATION_STATE_STOPPING: The replication is under the process of being stopped. This
   * is a transient state. - ASYNC_REPLICATION_STATE_STOPPED: The replication between the disk-pairs
   * have stopped. - ASYNC_REPLICATION_STATE_REPLICATING_BEHIND_CG_HIGH_CHURN: The replication is
   * lagging above the SLO limit for the disk in the consistency group due to disk's change rate
   * being above the supported limit.
   * @param dataReplicationState dataReplicationState or {@code null} for none
   */
  public DiskPairReplicationState setDataReplicationState(java.lang.String dataReplicationState) {
    this.dataReplicationState = dataReplicationState;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public ReplicationDiskPair getReplicationDiskPair() {
    return replicationDiskPair;
  }

  /**
   * @param replicationDiskPair replicationDiskPair or {@code null} for none
   */
  public DiskPairReplicationState setReplicationDiskPair(ReplicationDiskPair replicationDiskPair) {
    this.replicationDiskPair = replicationDiskPair;
    return this;
  }

  @Override
  public DiskPairReplicationState set(String fieldName, Object value) {
    return (DiskPairReplicationState) super.set(fieldName, value);
  }

  @Override
  public DiskPairReplicationState clone() {
    return (DiskPairReplicationState) super.clone();
  }

}
