/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A flexible specification of a time range that has 3 points of flexibility: (1) a flexible start
 * time, (2) a flexible end time, (3) a flexible duration. It is possible to specify a contradictory
 * time range that cannot be matched by any Interval. This causes a validation error.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FlexibleTimeRange extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTimeNotEarlierThan;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTimeNotLaterThan;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String maxDuration;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String minDuration;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTimeNotEarlierThan;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTimeNotLaterThan;

  /**
   * @return value or {@code null} for none
   */
  public String getEndTimeNotEarlierThan() {
    return endTimeNotEarlierThan;
  }

  /**
   * @param endTimeNotEarlierThan endTimeNotEarlierThan or {@code null} for none
   */
  public FlexibleTimeRange setEndTimeNotEarlierThan(String endTimeNotEarlierThan) {
    this.endTimeNotEarlierThan = endTimeNotEarlierThan;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public String getEndTimeNotLaterThan() {
    return endTimeNotLaterThan;
  }

  /**
   * @param endTimeNotLaterThan endTimeNotLaterThan or {@code null} for none
   */
  public FlexibleTimeRange setEndTimeNotLaterThan(String endTimeNotLaterThan) {
    this.endTimeNotLaterThan = endTimeNotLaterThan;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public String getMaxDuration() {
    return maxDuration;
  }

  /**
   * @param maxDuration maxDuration or {@code null} for none
   */
  public FlexibleTimeRange setMaxDuration(String maxDuration) {
    this.maxDuration = maxDuration;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public String getMinDuration() {
    return minDuration;
  }

  /**
   * @param minDuration minDuration or {@code null} for none
   */
  public FlexibleTimeRange setMinDuration(String minDuration) {
    this.minDuration = minDuration;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public String getStartTimeNotEarlierThan() {
    return startTimeNotEarlierThan;
  }

  /**
   * @param startTimeNotEarlierThan startTimeNotEarlierThan or {@code null} for none
   */
  public FlexibleTimeRange setStartTimeNotEarlierThan(String startTimeNotEarlierThan) {
    this.startTimeNotEarlierThan = startTimeNotEarlierThan;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public String getStartTimeNotLaterThan() {
    return startTimeNotLaterThan;
  }

  /**
   * @param startTimeNotLaterThan startTimeNotLaterThan or {@code null} for none
   */
  public FlexibleTimeRange setStartTimeNotLaterThan(String startTimeNotLaterThan) {
    this.startTimeNotLaterThan = startTimeNotLaterThan;
    return this;
  }

  @Override
  public FlexibleTimeRange set(String fieldName, Object value) {
    return (FlexibleTimeRange) super.set(fieldName, value);
  }

  @Override
  public FlexibleTimeRange clone() {
    return (FlexibleTimeRange) super.clone();
  }

}
