/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for FutureReservationCommitmentInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureReservationCommitmentInfo extends com.google.api.client.json.GenericJson {

  /**
   * name of the commitment where capacity is being delivered to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commitmentName;

  /**
   * Indicates if a Commitment needs to be created as part of FR delivery. If this field is not
   * present, then no commitment needs to be created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commitmentPlan;

  /**
   * Only applicable if FR is delivering to the same reservation. If set, all parent commitments
   * will be extended to match the end date of the plan for this commitment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String previousCommitmentTerms;

  /**
   * name of the commitment where capacity is being delivered to.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommitmentName() {
    return commitmentName;
  }

  /**
   * name of the commitment where capacity is being delivered to.
   * @param commitmentName commitmentName or {@code null} for none
   */
  public FutureReservationCommitmentInfo setCommitmentName(java.lang.String commitmentName) {
    this.commitmentName = commitmentName;
    return this;
  }

  /**
   * Indicates if a Commitment needs to be created as part of FR delivery. If this field is not
   * present, then no commitment needs to be created.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommitmentPlan() {
    return commitmentPlan;
  }

  /**
   * Indicates if a Commitment needs to be created as part of FR delivery. If this field is not
   * present, then no commitment needs to be created.
   * @param commitmentPlan commitmentPlan or {@code null} for none
   */
  public FutureReservationCommitmentInfo setCommitmentPlan(java.lang.String commitmentPlan) {
    this.commitmentPlan = commitmentPlan;
    return this;
  }

  /**
   * Only applicable if FR is delivering to the same reservation. If set, all parent commitments
   * will be extended to match the end date of the plan for this commitment.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreviousCommitmentTerms() {
    return previousCommitmentTerms;
  }

  /**
   * Only applicable if FR is delivering to the same reservation. If set, all parent commitments
   * will be extended to match the end date of the plan for this commitment.
   * @param previousCommitmentTerms previousCommitmentTerms or {@code null} for none
   */
  public FutureReservationCommitmentInfo setPreviousCommitmentTerms(java.lang.String previousCommitmentTerms) {
    this.previousCommitmentTerms = previousCommitmentTerms;
    return this;
  }

  @Override
  public FutureReservationCommitmentInfo set(String fieldName, Object value) {
    return (FutureReservationCommitmentInfo) super.set(fieldName, value);
  }

  @Override
  public FutureReservationCommitmentInfo clone() {
    return (FutureReservationCommitmentInfo) super.clone();
  }

}
