/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for FutureResourcesSpecAggregateResources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureResourcesSpecAggregateResources extends com.google.api.client.json.GenericJson {

  /**
   * Size of the request, in accelerator (chip) count.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long acceleratorCount;

  /**
   * The VM family that all instances scheduled against this reservation must belong to. Use for TPU
   * reservations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmFamily;

  /**
   * Workload type. Use for TPU reservations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workloadType;

  /**
   * Size of the request, in accelerator (chip) count.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAcceleratorCount() {
    return acceleratorCount;
  }

  /**
   * Size of the request, in accelerator (chip) count.
   * @param acceleratorCount acceleratorCount or {@code null} for none
   */
  public FutureResourcesSpecAggregateResources setAcceleratorCount(java.lang.Long acceleratorCount) {
    this.acceleratorCount = acceleratorCount;
    return this;
  }

  /**
   * The VM family that all instances scheduled against this reservation must belong to. Use for TPU
   * reservations.
   * @return value or {@code null} for none
   */
  public java.lang.String getVmFamily() {
    return vmFamily;
  }

  /**
   * The VM family that all instances scheduled against this reservation must belong to. Use for TPU
   * reservations.
   * @param vmFamily vmFamily or {@code null} for none
   */
  public FutureResourcesSpecAggregateResources setVmFamily(java.lang.String vmFamily) {
    this.vmFamily = vmFamily;
    return this;
  }

  /**
   * Workload type. Use for TPU reservations.
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkloadType() {
    return workloadType;
  }

  /**
   * Workload type. Use for TPU reservations.
   * @param workloadType workloadType or {@code null} for none
   */
  public FutureResourcesSpecAggregateResources setWorkloadType(java.lang.String workloadType) {
    this.workloadType = workloadType;
    return this;
  }

  @Override
  public FutureResourcesSpecAggregateResources set(String fieldName, Object value) {
    return (FutureResourcesSpecAggregateResources) super.set(fieldName, value);
  }

  @Override
  public FutureResourcesSpecAggregateResources clone() {
    return (FutureResourcesSpecAggregateResources) super.clone();
  }

}
