/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * HttpFilterConfiguration supplies additional contextual settings for networkservices.HttpFilter
 * resources enabled by Traffic Director.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpFilterConfig extends com.google.api.client.json.GenericJson {

  /**
   * The configuration needed to enable the networkservices.HttpFilter resource. The configuration
   * must be YAML formatted and only contain fields defined in the protobuf identified in
   * configTypeUrl
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String config;

  /**
   * The fully qualified versioned proto3 type url of the protobuf that the filter expects for its
   * contextual settings, for example: type.googleapis.com/google.protobuf.Struct
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String configTypeUrl;

  /**
   * Name of the networkservices.HttpFilter resource this configuration belongs to. This name must
   * be known to the xDS client. Example: envoy.wasm
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filterName;

  /**
   * The configuration needed to enable the networkservices.HttpFilter resource. The configuration
   * must be YAML formatted and only contain fields defined in the protobuf identified in
   * configTypeUrl
   * @return value or {@code null} for none
   */
  public java.lang.String getConfig() {
    return config;
  }

  /**
   * The configuration needed to enable the networkservices.HttpFilter resource. The configuration
   * must be YAML formatted and only contain fields defined in the protobuf identified in
   * configTypeUrl
   * @param config config or {@code null} for none
   */
  public HttpFilterConfig setConfig(java.lang.String config) {
    this.config = config;
    return this;
  }

  /**
   * The fully qualified versioned proto3 type url of the protobuf that the filter expects for its
   * contextual settings, for example: type.googleapis.com/google.protobuf.Struct
   * @return value or {@code null} for none
   */
  public java.lang.String getConfigTypeUrl() {
    return configTypeUrl;
  }

  /**
   * The fully qualified versioned proto3 type url of the protobuf that the filter expects for its
   * contextual settings, for example: type.googleapis.com/google.protobuf.Struct
   * @param configTypeUrl configTypeUrl or {@code null} for none
   */
  public HttpFilterConfig setConfigTypeUrl(java.lang.String configTypeUrl) {
    this.configTypeUrl = configTypeUrl;
    return this;
  }

  /**
   * Name of the networkservices.HttpFilter resource this configuration belongs to. This name must
   * be known to the xDS client. Example: envoy.wasm
   * @return value or {@code null} for none
   */
  public java.lang.String getFilterName() {
    return filterName;
  }

  /**
   * Name of the networkservices.HttpFilter resource this configuration belongs to. This name must
   * be known to the xDS client. Example: envoy.wasm
   * @param filterName filterName or {@code null} for none
   */
  public HttpFilterConfig setFilterName(java.lang.String filterName) {
    this.filterName = filterName;
    return this;
  }

  @Override
  public HttpFilterConfig set(String fieldName, Object value) {
    return (HttpFilterConfig) super.set(fieldName, value);
  }

  @Override
  public HttpFilterConfig clone() {
    return (HttpFilterConfig) super.clone();
  }

}
