/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerAutoHealingPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerAutoHealingPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Restricts what triggers autohealing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers autoHealingTriggers;

  /**
   * The URL for the health check that signals autohealing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String healthCheck;

  /**
   * The initial delay is the number of seconds that a new VM takes to initialize and run its
   * startup script. During a VM's initial delay period, the MIG ignores unsuccessful health checks
   * because the VM might be in the startup process. This prevents the MIG from prematurely
   * recreating a VM. If the health check receives a healthy response during the initial delay, it
   * indicates that the startup process is complete and the VM is ready. The value of initial delay
   * must be between 0 and 3600 seconds. The default value is 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer initialDelaySec;

  /**
   * Maximum number of instances that can be unavailable when autohealing. When 'percent' is used,
   * the value is rounded if necessary. The instance is considered available if all of the following
   * conditions are satisfied: 1. Instance's status is RUNNING. 2. Instance's currentAction is NONE
   * (in particular its liveness health check result was observed to be HEALTHY at least once as it
   * passed VERIFYING). 3. There is no outgoing action on an instance triggered by IGM. By default,
   * number of concurrently autohealed instances is smaller than the managed instance group target
   * size. However, if a zonal managed instance group has only one instance, or a regional managed
   * instance group has only one instance per zone, autohealing will recreate these instances when
   * they become unhealthy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FixedOrPercent maxUnavailable;

  /**
   * Restricts what triggers autohealing.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers getAutoHealingTriggers() {
    return autoHealingTriggers;
  }

  /**
   * Restricts what triggers autohealing.
   * @param autoHealingTriggers autoHealingTriggers or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicy setAutoHealingTriggers(InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers autoHealingTriggers) {
    this.autoHealingTriggers = autoHealingTriggers;
    return this;
  }

  /**
   * The URL for the health check that signals autohealing.
   * @return value or {@code null} for none
   */
  public java.lang.String getHealthCheck() {
    return healthCheck;
  }

  /**
   * The URL for the health check that signals autohealing.
   * @param healthCheck healthCheck or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicy setHealthCheck(java.lang.String healthCheck) {
    this.healthCheck = healthCheck;
    return this;
  }

  /**
   * The initial delay is the number of seconds that a new VM takes to initialize and run its
   * startup script. During a VM's initial delay period, the MIG ignores unsuccessful health checks
   * because the VM might be in the startup process. This prevents the MIG from prematurely
   * recreating a VM. If the health check receives a healthy response during the initial delay, it
   * indicates that the startup process is complete and the VM is ready. The value of initial delay
   * must be between 0 and 3600 seconds. The default value is 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInitialDelaySec() {
    return initialDelaySec;
  }

  /**
   * The initial delay is the number of seconds that a new VM takes to initialize and run its
   * startup script. During a VM's initial delay period, the MIG ignores unsuccessful health checks
   * because the VM might be in the startup process. This prevents the MIG from prematurely
   * recreating a VM. If the health check receives a healthy response during the initial delay, it
   * indicates that the startup process is complete and the VM is ready. The value of initial delay
   * must be between 0 and 3600 seconds. The default value is 0.
   * @param initialDelaySec initialDelaySec or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicy setInitialDelaySec(java.lang.Integer initialDelaySec) {
    this.initialDelaySec = initialDelaySec;
    return this;
  }

  /**
   * Maximum number of instances that can be unavailable when autohealing. When 'percent' is used,
   * the value is rounded if necessary. The instance is considered available if all of the following
   * conditions are satisfied: 1. Instance's status is RUNNING. 2. Instance's currentAction is NONE
   * (in particular its liveness health check result was observed to be HEALTHY at least once as it
   * passed VERIFYING). 3. There is no outgoing action on an instance triggered by IGM. By default,
   * number of concurrently autohealed instances is smaller than the managed instance group target
   * size. However, if a zonal managed instance group has only one instance, or a regional managed
   * instance group has only one instance per zone, autohealing will recreate these instances when
   * they become unhealthy.
   * @return value or {@code null} for none
   */
  public FixedOrPercent getMaxUnavailable() {
    return maxUnavailable;
  }

  /**
   * Maximum number of instances that can be unavailable when autohealing. When 'percent' is used,
   * the value is rounded if necessary. The instance is considered available if all of the following
   * conditions are satisfied: 1. Instance's status is RUNNING. 2. Instance's currentAction is NONE
   * (in particular its liveness health check result was observed to be HEALTHY at least once as it
   * passed VERIFYING). 3. There is no outgoing action on an instance triggered by IGM. By default,
   * number of concurrently autohealed instances is smaller than the managed instance group target
   * size. However, if a zonal managed instance group has only one instance, or a regional managed
   * instance group has only one instance per zone, autohealing will recreate these instances when
   * they become unhealthy.
   * @param maxUnavailable maxUnavailable or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicy setMaxUnavailable(FixedOrPercent maxUnavailable) {
    this.maxUnavailable = maxUnavailable;
    return this;
  }

  @Override
  public InstanceGroupManagerAutoHealingPolicy set(String fieldName, Object value) {
    return (InstanceGroupManagerAutoHealingPolicy) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerAutoHealingPolicy clone() {
    return (InstanceGroupManagerAutoHealingPolicy) super.clone();
  }

}
