/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers extends com.google.api.client.json.GenericJson {

  /**
   * If you have configured an application-based health check for the group, this field controls
   * whether to trigger VM autohealing based on a failed health check. Valid values are: - ON
   * (default): The group recreates running VMs that fail the application-based health check. - OFF:
   * When set to OFF, you can still observe instance health state, but the group does not recreate
   * VMs that fail the application-based health check. This is useful for troubleshooting and
   * setting up your health check configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String onHealthCheck;

  /**
   * If you have configured an application-based health check for the group, this field controls
   * whether to trigger VM autohealing based on a failed health check. Valid values are: - ON
   * (default): The group recreates running VMs that fail the application-based health check. - OFF:
   * When set to OFF, you can still observe instance health state, but the group does not recreate
   * VMs that fail the application-based health check. This is useful for troubleshooting and
   * setting up your health check configuration.
   * @return value or {@code null} for none
   */
  public java.lang.String getOnHealthCheck() {
    return onHealthCheck;
  }

  /**
   * If you have configured an application-based health check for the group, this field controls
   * whether to trigger VM autohealing based on a failed health check. Valid values are: - ON
   * (default): The group recreates running VMs that fail the application-based health check. - OFF:
   * When set to OFF, you can still observe instance health state, but the group does not recreate
   * VMs that fail the application-based health check. This is useful for troubleshooting and
   * setting up your health check configuration.
   * @param onHealthCheck onHealthCheck or {@code null} for none
   */
  public InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers setOnHealthCheck(java.lang.String onHealthCheck) {
    this.onHealthCheck = onHealthCheck;
    return this;
  }

  @Override
  public InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers set(String fieldName, Object value) {
    return (InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers clone() {
    return (InstanceGroupManagerAutoHealingPolicyAutoHealingTriggers) super.clone();
  }

}
