/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] Status of all-instances configuration on the group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerStatusAllInstancesConfig allInstancesConfig;

  /**
   * [Output Only] The URL of the Autoscaler that targets this instance group manager.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String autoscaler;

  /**
   * [Output Only] Status of bulk instance operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerStatusBulkInstanceOperation bulkInstanceOperation;

  /**
   * [Output Only] A bit indicating whether the managed instance group is in a stable state. A
   * stable state means that: none of the instances in the managed instance group is currently
   * undergoing any type of change (for example, creation, restart, or deletion); no future changes
   * are scheduled for instances in the managed instance group; and the managed instance group
   * itself is not being modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isStable;

  /**
   * [Output Only] Stateful status of the given Instance Group Manager.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerStatusStateful stateful;

  /**
   * [Output Only] A status of consistency of Instances' versions with their target version
   * specified by version field on Instance Group Manager.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerStatusVersionTarget versionTarget;

  /**
   * [Output only] Status of all-instances configuration on the group.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerStatusAllInstancesConfig getAllInstancesConfig() {
    return allInstancesConfig;
  }

  /**
   * [Output only] Status of all-instances configuration on the group.
   * @param allInstancesConfig allInstancesConfig or {@code null} for none
   */
  public InstanceGroupManagerStatus setAllInstancesConfig(InstanceGroupManagerStatusAllInstancesConfig allInstancesConfig) {
    this.allInstancesConfig = allInstancesConfig;
    return this;
  }

  /**
   * [Output Only] The URL of the Autoscaler that targets this instance group manager.
   * @return value or {@code null} for none
   */
  public java.lang.String getAutoscaler() {
    return autoscaler;
  }

  /**
   * [Output Only] The URL of the Autoscaler that targets this instance group manager.
   * @param autoscaler autoscaler or {@code null} for none
   */
  public InstanceGroupManagerStatus setAutoscaler(java.lang.String autoscaler) {
    this.autoscaler = autoscaler;
    return this;
  }

  /**
   * [Output Only] Status of bulk instance operation.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerStatusBulkInstanceOperation getBulkInstanceOperation() {
    return bulkInstanceOperation;
  }

  /**
   * [Output Only] Status of bulk instance operation.
   * @param bulkInstanceOperation bulkInstanceOperation or {@code null} for none
   */
  public InstanceGroupManagerStatus setBulkInstanceOperation(InstanceGroupManagerStatusBulkInstanceOperation bulkInstanceOperation) {
    this.bulkInstanceOperation = bulkInstanceOperation;
    return this;
  }

  /**
   * [Output Only] A bit indicating whether the managed instance group is in a stable state. A
   * stable state means that: none of the instances in the managed instance group is currently
   * undergoing any type of change (for example, creation, restart, or deletion); no future changes
   * are scheduled for instances in the managed instance group; and the managed instance group
   * itself is not being modified.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsStable() {
    return isStable;
  }

  /**
   * [Output Only] A bit indicating whether the managed instance group is in a stable state. A
   * stable state means that: none of the instances in the managed instance group is currently
   * undergoing any type of change (for example, creation, restart, or deletion); no future changes
   * are scheduled for instances in the managed instance group; and the managed instance group
   * itself is not being modified.
   * @param isStable isStable or {@code null} for none
   */
  public InstanceGroupManagerStatus setIsStable(java.lang.Boolean isStable) {
    this.isStable = isStable;
    return this;
  }

  /**
   * [Output Only] Stateful status of the given Instance Group Manager.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerStatusStateful getStateful() {
    return stateful;
  }

  /**
   * [Output Only] Stateful status of the given Instance Group Manager.
   * @param stateful stateful or {@code null} for none
   */
  public InstanceGroupManagerStatus setStateful(InstanceGroupManagerStatusStateful stateful) {
    this.stateful = stateful;
    return this;
  }

  /**
   * [Output Only] A status of consistency of Instances' versions with their target version
   * specified by version field on Instance Group Manager.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerStatusVersionTarget getVersionTarget() {
    return versionTarget;
  }

  /**
   * [Output Only] A status of consistency of Instances' versions with their target version
   * specified by version field on Instance Group Manager.
   * @param versionTarget versionTarget or {@code null} for none
   */
  public InstanceGroupManagerStatus setVersionTarget(InstanceGroupManagerStatusVersionTarget versionTarget) {
    this.versionTarget = versionTarget;
    return this;
  }

  @Override
  public InstanceGroupManagerStatus set(String fieldName, Object value) {
    return (InstanceGroupManagerStatus) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerStatus clone() {
    return (InstanceGroupManagerStatus) super.clone();
  }

}
