/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerStatusBulkInstanceOperation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerStatusBulkInstanceOperation extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Informs whether bulk instance operation is in progress.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean inProgress;

  /**
   * [Output Only] Information from last progress check of bulk instance operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerStatusBulkInstanceOperationLastProgressCheck lastProgressCheck;

  /**
   * [Output Only] Informs whether bulk instance operation is in progress.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInProgress() {
    return inProgress;
  }

  /**
   * [Output Only] Informs whether bulk instance operation is in progress.
   * @param inProgress inProgress or {@code null} for none
   */
  public InstanceGroupManagerStatusBulkInstanceOperation setInProgress(java.lang.Boolean inProgress) {
    this.inProgress = inProgress;
    return this;
  }

  /**
   * [Output Only] Information from last progress check of bulk instance operation.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerStatusBulkInstanceOperationLastProgressCheck getLastProgressCheck() {
    return lastProgressCheck;
  }

  /**
   * [Output Only] Information from last progress check of bulk instance operation.
   * @param lastProgressCheck lastProgressCheck or {@code null} for none
   */
  public InstanceGroupManagerStatusBulkInstanceOperation setLastProgressCheck(InstanceGroupManagerStatusBulkInstanceOperationLastProgressCheck lastProgressCheck) {
    this.lastProgressCheck = lastProgressCheck;
    return this;
  }

  @Override
  public InstanceGroupManagerStatusBulkInstanceOperation set(String fieldName, Object value) {
    return (InstanceGroupManagerStatusBulkInstanceOperation) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerStatusBulkInstanceOperation clone() {
    return (InstanceGroupManagerStatusBulkInstanceOperation) super.clone();
  }

}
