/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstantSnapshotGroupParameters.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstantSnapshotGroupParameters extends com.google.api.client.json.GenericJson {

  /**
   * The source instant snapshot group used to create disks. You can provide this as a partial or
   * full URL to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone
   * /instantSnapshotGroups/instantSnapshotGroup -
   * projects/project/zones/zone/instantSnapshotGroups/instantSnapshotGroup -
   * zones/zone/instantSnapshotGroups/instantSnapshotGroup
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceInstantSnapshotGroup;

  /**
   * The source instant snapshot group used to create disks. You can provide this as a partial or
   * full URL to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone
   * /instantSnapshotGroups/instantSnapshotGroup -
   * projects/project/zones/zone/instantSnapshotGroups/instantSnapshotGroup -
   * zones/zone/instantSnapshotGroups/instantSnapshotGroup
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceInstantSnapshotGroup() {
    return sourceInstantSnapshotGroup;
  }

  /**
   * The source instant snapshot group used to create disks. You can provide this as a partial or
   * full URL to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone
   * /instantSnapshotGroups/instantSnapshotGroup -
   * projects/project/zones/zone/instantSnapshotGroups/instantSnapshotGroup -
   * zones/zone/instantSnapshotGroups/instantSnapshotGroup
   * @param sourceInstantSnapshotGroup sourceInstantSnapshotGroup or {@code null} for none
   */
  public InstantSnapshotGroupParameters setSourceInstantSnapshotGroup(java.lang.String sourceInstantSnapshotGroup) {
    this.sourceInstantSnapshotGroup = sourceInstantSnapshotGroup;
    return this;
  }

  @Override
  public InstantSnapshotGroupParameters set(String fieldName, Object value) {
    return (InstantSnapshotGroupParameters) super.set(fieldName, value);
  }

  @Override
  public InstantSnapshotGroupParameters clone() {
    return (InstantSnapshotGroupParameters) super.clone();
  }

}
