/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InterconnectAttachmentGroupsCreateMembers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentGroupsCreateMembers extends com.google.api.client.json.GenericJson {

  /**
   * Parameters for the specific Attachments to create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput> attachments;

  /**
   * How to behave when configured.availabilitySLA.effectiveSLA would not equal
   * intent.availabilitySLA after this call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String intentMismatchBehavior;

  /**
   * Default parameters for the Attachments to create in this call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput templateAttachment;

  /**
   * Parameters for the specific Attachments to create.
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput> getAttachments() {
    return attachments;
  }

  /**
   * Parameters for the specific Attachments to create.
   * @param attachments attachments or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembers setAttachments(java.util.List<InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput> attachments) {
    this.attachments = attachments;
    return this;
  }

  /**
   * How to behave when configured.availabilitySLA.effectiveSLA would not equal
   * intent.availabilitySLA after this call.
   * @return value or {@code null} for none
   */
  public java.lang.String getIntentMismatchBehavior() {
    return intentMismatchBehavior;
  }

  /**
   * How to behave when configured.availabilitySLA.effectiveSLA would not equal
   * intent.availabilitySLA after this call.
   * @param intentMismatchBehavior intentMismatchBehavior or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembers setIntentMismatchBehavior(java.lang.String intentMismatchBehavior) {
    this.intentMismatchBehavior = intentMismatchBehavior;
    return this;
  }

  /**
   * Default parameters for the Attachments to create in this call.
   * @return value or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput getTemplateAttachment() {
    return templateAttachment;
  }

  /**
   * Default parameters for the Attachments to create in this call.
   * @param templateAttachment templateAttachment or {@code null} for none
   */
  public InterconnectAttachmentGroupsCreateMembers setTemplateAttachment(InterconnectAttachmentGroupsCreateMembersInterconnectAttachmentInput templateAttachment) {
    this.templateAttachment = templateAttachment;
    return this;
  }

  @Override
  public InterconnectAttachmentGroupsCreateMembers set(String fieldName, Object value) {
    return (InterconnectAttachmentGroupsCreateMembers) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentGroupsCreateMembers clone() {
    return (InterconnectAttachmentGroupsCreateMembers) super.clone();
  }

}
