/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Two-level VLAN-to-Appliance mapping rule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectAttachmentL2ForwardingApplianceMapping extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A single IPv4 or IPv6 address used as the destination IP address for ingress packets
   * that match on a VLAN tag, but do not match a more specific inner VLAN tag. Unset field (null-
   * value) indicates both VLAN tags are required to be mapped. Otherwise, defaultApplianceIpAddress
   * is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String applianceIpAddress;

  /**
   * Optional. Used to match against the inner VLAN when the packet contains two VLAN tags. A list
   * of mapping rules from inner VLAN tags to IP addresses. If the inner VLAN is not explicitly
   * mapped to an IP address range, the applianceIpAddress is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InterconnectAttachmentL2ForwardingApplianceMappingInnerVlanToApplianceMapping> innerVlanToApplianceMappings;

  /**
   * Optional. The name of this appliance mapping rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. A single IPv4 or IPv6 address used as the destination IP address for ingress packets
   * that match on a VLAN tag, but do not match a more specific inner VLAN tag. Unset field (null-
   * value) indicates both VLAN tags are required to be mapped. Otherwise, defaultApplianceIpAddress
   * is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getApplianceIpAddress() {
    return applianceIpAddress;
  }

  /**
   * Optional. A single IPv4 or IPv6 address used as the destination IP address for ingress packets
   * that match on a VLAN tag, but do not match a more specific inner VLAN tag. Unset field (null-
   * value) indicates both VLAN tags are required to be mapped. Otherwise, defaultApplianceIpAddress
   * is used.
   * @param applianceIpAddress applianceIpAddress or {@code null} for none
   */
  public InterconnectAttachmentL2ForwardingApplianceMapping setApplianceIpAddress(java.lang.String applianceIpAddress) {
    this.applianceIpAddress = applianceIpAddress;
    return this;
  }

  /**
   * Optional. Used to match against the inner VLAN when the packet contains two VLAN tags. A list
   * of mapping rules from inner VLAN tags to IP addresses. If the inner VLAN is not explicitly
   * mapped to an IP address range, the applianceIpAddress is used.
   * @return value or {@code null} for none
   */
  public java.util.List<InterconnectAttachmentL2ForwardingApplianceMappingInnerVlanToApplianceMapping> getInnerVlanToApplianceMappings() {
    return innerVlanToApplianceMappings;
  }

  /**
   * Optional. Used to match against the inner VLAN when the packet contains two VLAN tags. A list
   * of mapping rules from inner VLAN tags to IP addresses. If the inner VLAN is not explicitly
   * mapped to an IP address range, the applianceIpAddress is used.
   * @param innerVlanToApplianceMappings innerVlanToApplianceMappings or {@code null} for none
   */
  public InterconnectAttachmentL2ForwardingApplianceMapping setInnerVlanToApplianceMappings(java.util.List<InterconnectAttachmentL2ForwardingApplianceMappingInnerVlanToApplianceMapping> innerVlanToApplianceMappings) {
    this.innerVlanToApplianceMappings = innerVlanToApplianceMappings;
    return this;
  }

  /**
   * Optional. The name of this appliance mapping rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Optional. The name of this appliance mapping rule.
   * @param name name or {@code null} for none
   */
  public InterconnectAttachmentL2ForwardingApplianceMapping setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public InterconnectAttachmentL2ForwardingApplianceMapping set(String fieldName, Object value) {
    return (InterconnectAttachmentL2ForwardingApplianceMapping) super.set(fieldName, value);
  }

  @Override
  public InterconnectAttachmentL2ForwardingApplianceMapping clone() {
    return (InterconnectAttachmentL2ForwardingApplianceMapping) super.clone();
  }

}
