/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The status of one Interconnect in the group. The order is arbitrary.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectGroupsOperationalStatusInterconnectStatus extends com.google.api.client.json.GenericJson {

  /**
   * Whether the Interconnect is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adminEnabled;

  /**
   * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterconnectDiagnostics diagnostics;

  /**
   * The URL of the Interconnect being described.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String interconnect;

  /**
   * Whether this interconnect is participating in the redundant configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String isActive;

  /**
   * Whether the Interconnect is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdminEnabled() {
    return adminEnabled;
  }

  /**
   * Whether the Interconnect is enabled.
   * @param adminEnabled adminEnabled or {@code null} for none
   */
  public InterconnectGroupsOperationalStatusInterconnectStatus setAdminEnabled(java.lang.Boolean adminEnabled) {
    this.adminEnabled = adminEnabled;
    return this;
  }

  /**
   * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
   * @return value or {@code null} for none
   */
  public InterconnectDiagnostics getDiagnostics() {
    return diagnostics;
  }

  /**
   * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
   * @param diagnostics diagnostics or {@code null} for none
   */
  public InterconnectGroupsOperationalStatusInterconnectStatus setDiagnostics(InterconnectDiagnostics diagnostics) {
    this.diagnostics = diagnostics;
    return this;
  }

  /**
   * The URL of the Interconnect being described.
   * @return value or {@code null} for none
   */
  public java.lang.String getInterconnect() {
    return interconnect;
  }

  /**
   * The URL of the Interconnect being described.
   * @param interconnect interconnect or {@code null} for none
   */
  public InterconnectGroupsOperationalStatusInterconnectStatus setInterconnect(java.lang.String interconnect) {
    this.interconnect = interconnect;
    return this;
  }

  /**
   * Whether this interconnect is participating in the redundant configuration.
   * @return value or {@code null} for none
   */
  public java.lang.String getIsActive() {
    return isActive;
  }

  /**
   * Whether this interconnect is participating in the redundant configuration.
   * @param isActive isActive or {@code null} for none
   */
  public InterconnectGroupsOperationalStatusInterconnectStatus setIsActive(java.lang.String isActive) {
    this.isActive = isActive;
    return this;
  }

  @Override
  public InterconnectGroupsOperationalStatusInterconnectStatus set(String fieldName, Object value) {
    return (InterconnectGroupsOperationalStatusInterconnectStatus) super.set(fieldName, value);
  }

  @Override
  public InterconnectGroupsOperationalStatusInterconnectStatus clone() {
    return (InterconnectGroupsOperationalStatusInterconnectStatus) super.clone();
  }

}
