/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ManagedInstanceCurrentActionDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedInstanceCurrentActionDetails extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String methodName;

  /**
   * [Output Only] Details of the current action that the managed instance group has scheduled for
   * the instance. Contains trigger for the current action, and methodName in case it was triggered
   * by API call. Possible values for trigger: - API Any API call. - PROACTIVE_UPDATE Proactive
   * updater scheduled an update on this managed instance. - AUTOSCALING Instance being
   * deleted/created after a decision from the Autoscaler. - REDISTRIBUTION The regional managed
   * instance group is moving instances between zones to restore balance. - STANDBY_REFILL The
   * managed instance group is refilling the Standby Pool (stopped/suspended virtual machines) after
   * scale up. - MAINTENANCE Manual maintenance. - FAILED_CREATION The managed instance group is
   * handling failed instance creation. - INSTANCE_FAILURE The managed instance group is handling
   * instance failure, according to the Instance Lifecycle Policy. - FAILED_HEALTH_CHECK The managed
   * instance group is handling failed health check, according to the Instance Lifecycle Policy. -
   * TERMINATION_TIMESTAMP Instance reached termination time, thus managed instance group
   * stops/deletes it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trigger;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getMethodName() {
    return methodName;
  }

  /**
   * @param methodName methodName or {@code null} for none
   */
  public ManagedInstanceCurrentActionDetails setMethodName(java.lang.String methodName) {
    this.methodName = methodName;
    return this;
  }

  /**
   * [Output Only] Details of the current action that the managed instance group has scheduled for
   * the instance. Contains trigger for the current action, and methodName in case it was triggered
   * by API call. Possible values for trigger: - API Any API call. - PROACTIVE_UPDATE Proactive
   * updater scheduled an update on this managed instance. - AUTOSCALING Instance being
   * deleted/created after a decision from the Autoscaler. - REDISTRIBUTION The regional managed
   * instance group is moving instances between zones to restore balance. - STANDBY_REFILL The
   * managed instance group is refilling the Standby Pool (stopped/suspended virtual machines) after
   * scale up. - MAINTENANCE Manual maintenance. - FAILED_CREATION The managed instance group is
   * handling failed instance creation. - INSTANCE_FAILURE The managed instance group is handling
   * instance failure, according to the Instance Lifecycle Policy. - FAILED_HEALTH_CHECK The managed
   * instance group is handling failed health check, according to the Instance Lifecycle Policy. -
   * TERMINATION_TIMESTAMP Instance reached termination time, thus managed instance group
   * stops/deletes it.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrigger() {
    return trigger;
  }

  /**
   * [Output Only] Details of the current action that the managed instance group has scheduled for
   * the instance. Contains trigger for the current action, and methodName in case it was triggered
   * by API call. Possible values for trigger: - API Any API call. - PROACTIVE_UPDATE Proactive
   * updater scheduled an update on this managed instance. - AUTOSCALING Instance being
   * deleted/created after a decision from the Autoscaler. - REDISTRIBUTION The regional managed
   * instance group is moving instances between zones to restore balance. - STANDBY_REFILL The
   * managed instance group is refilling the Standby Pool (stopped/suspended virtual machines) after
   * scale up. - MAINTENANCE Manual maintenance. - FAILED_CREATION The managed instance group is
   * handling failed instance creation. - INSTANCE_FAILURE The managed instance group is handling
   * instance failure, according to the Instance Lifecycle Policy. - FAILED_HEALTH_CHECK The managed
   * instance group is handling failed health check, according to the Instance Lifecycle Policy. -
   * TERMINATION_TIMESTAMP Instance reached termination time, thus managed instance group
   * stops/deletes it.
   * @param trigger trigger or {@code null} for none
   */
  public ManagedInstanceCurrentActionDetails setTrigger(java.lang.String trigger) {
    this.trigger = trigger;
    return this;
  }

  @Override
  public ManagedInstanceCurrentActionDetails set(String fieldName, Object value) {
    return (ManagedInstanceCurrentActionDetails) super.set(fieldName, value);
  }

  @Override
  public ManagedInstanceCurrentActionDetails clone() {
    return (ManagedInstanceCurrentActionDetails) super.clone();
  }

}
