/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Surfaces relevant state for a consensus peering connection update/delete semantics. Only set when
 * connection_status.update_strategy is CONSENSUS or one network peering is proposing upgrading to
 * CONSENSUS.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkPeeringConnectionStatusConsensusState extends com.google.api.client.json.GenericJson {

  /**
   * The status of the delete request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deleteStatus;

  /**
   * The status of the update request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updateStatus;

  /**
   * The status of the delete request.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeleteStatus() {
    return deleteStatus;
  }

  /**
   * The status of the delete request.
   * @param deleteStatus deleteStatus or {@code null} for none
   */
  public NetworkPeeringConnectionStatusConsensusState setDeleteStatus(java.lang.String deleteStatus) {
    this.deleteStatus = deleteStatus;
    return this;
  }

  /**
   * The status of the update request.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdateStatus() {
    return updateStatus;
  }

  /**
   * The status of the update request.
   * @param updateStatus updateStatus or {@code null} for none
   */
  public NetworkPeeringConnectionStatusConsensusState setUpdateStatus(java.lang.String updateStatus) {
    this.updateStatus = updateStatus;
    return this;
  }

  @Override
  public NetworkPeeringConnectionStatusConsensusState set(String fieldName, Object value) {
    return (NetworkPeeringConnectionStatusConsensusState) super.set(fieldName, value);
  }

  @Override
  public NetworkPeeringConnectionStatusConsensusState clone() {
    return (NetworkPeeringConnectionStatusConsensusState) super.clone();
  }

}
