/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for NetworkPeeringConnectionStatusTrafficConfiguration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkPeeringConnectionStatusTrafficConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * Whether custom routes are being exported to the peer network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean exportCustomRoutesToPeer;

  /**
   * Whether subnet routes with public IP range are being exported to the peer network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean exportSubnetRoutesWithPublicIpToPeer;

  /**
   * Whether custom routes is being imported from the peer network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean importCustomRoutesFromPeer;

  /**
   * Whether subnet routes with public IP range are being imported from the peer network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean importSubnetRoutesWithPublicIpFromPeer;

  /**
   * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stackType;

  /**
   * Whether custom routes are being exported to the peer network.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExportCustomRoutesToPeer() {
    return exportCustomRoutesToPeer;
  }

  /**
   * Whether custom routes are being exported to the peer network.
   * @param exportCustomRoutesToPeer exportCustomRoutesToPeer or {@code null} for none
   */
  public NetworkPeeringConnectionStatusTrafficConfiguration setExportCustomRoutesToPeer(java.lang.Boolean exportCustomRoutesToPeer) {
    this.exportCustomRoutesToPeer = exportCustomRoutesToPeer;
    return this;
  }

  /**
   * Whether subnet routes with public IP range are being exported to the peer network.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExportSubnetRoutesWithPublicIpToPeer() {
    return exportSubnetRoutesWithPublicIpToPeer;
  }

  /**
   * Whether subnet routes with public IP range are being exported to the peer network.
   * @param exportSubnetRoutesWithPublicIpToPeer exportSubnetRoutesWithPublicIpToPeer or {@code null} for none
   */
  public NetworkPeeringConnectionStatusTrafficConfiguration setExportSubnetRoutesWithPublicIpToPeer(java.lang.Boolean exportSubnetRoutesWithPublicIpToPeer) {
    this.exportSubnetRoutesWithPublicIpToPeer = exportSubnetRoutesWithPublicIpToPeer;
    return this;
  }

  /**
   * Whether custom routes is being imported from the peer network.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getImportCustomRoutesFromPeer() {
    return importCustomRoutesFromPeer;
  }

  /**
   * Whether custom routes is being imported from the peer network.
   * @param importCustomRoutesFromPeer importCustomRoutesFromPeer or {@code null} for none
   */
  public NetworkPeeringConnectionStatusTrafficConfiguration setImportCustomRoutesFromPeer(java.lang.Boolean importCustomRoutesFromPeer) {
    this.importCustomRoutesFromPeer = importCustomRoutesFromPeer;
    return this;
  }

  /**
   * Whether subnet routes with public IP range are being imported from the peer network.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getImportSubnetRoutesWithPublicIpFromPeer() {
    return importSubnetRoutesWithPublicIpFromPeer;
  }

  /**
   * Whether subnet routes with public IP range are being imported from the peer network.
   * @param importSubnetRoutesWithPublicIpFromPeer importSubnetRoutesWithPublicIpFromPeer or {@code null} for none
   */
  public NetworkPeeringConnectionStatusTrafficConfiguration setImportSubnetRoutesWithPublicIpFromPeer(java.lang.Boolean importSubnetRoutesWithPublicIpFromPeer) {
    this.importSubnetRoutesWithPublicIpFromPeer = importSubnetRoutesWithPublicIpFromPeer;
    return this;
  }

  /**
   * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
   * @return value or {@code null} for none
   */
  public java.lang.String getStackType() {
    return stackType;
  }

  /**
   * Which IP version(s) of traffic and routes are being imported or exported between peer networks.
   * @param stackType stackType or {@code null} for none
   */
  public NetworkPeeringConnectionStatusTrafficConfiguration setStackType(java.lang.String stackType) {
    this.stackType = stackType;
    return this;
  }

  @Override
  public NetworkPeeringConnectionStatusTrafficConfiguration set(String fieldName, Object value) {
    return (NetworkPeeringConnectionStatusTrafficConfiguration) super.set(fieldName, value);
  }

  @Override
  public NetworkPeeringConnectionStatusTrafficConfiguration clone() {
    return (NetworkPeeringConnectionStatusTrafficConfiguration) super.clone();
  }

}
