/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A path-matching rule for a URL. If matched, will use the specified BackendService to handle the
 * traffic arriving at this URL.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PathRule extends com.google.api.client.json.GenericJson {

  /**
   * customErrorResponsePolicy specifies how the Load Balancer returns error responses when
   * BackendServiceor BackendBucket responds with an error. If a policy for an error code is not
   * configured for the PathRule, a policy for the error code configured in
   * pathMatcher.defaultCustomErrorResponsePolicy is applied. If one is not specified in
   * pathMatcher.defaultCustomErrorResponsePolicy, the policy configured in
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the
   * following configuration: - UrlMap.defaultCustomErrorResponsePolicy are configured with policies
   * for 5xx and 4xx errors - A PathRule for /coming_soon/ is configured for the error code 404. If
   * the request is for www.myotherdomain.com and a 404 is encountered, the policy under
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the
   * request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the
   * request for www.example.com/coming_soon/ encounters a 404, the policy in
   * PathRule.customErrorResponsePolicy takes effect. If any of the requests in this example
   * encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect.
   * customErrorResponsePolicy is supported only for global external Application Load Balancers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomErrorResponsePolicy customErrorResponsePolicy;

  /**
   * The list of path patterns to match. Each must start with / and the only place a * is allowed is
   * at the end following a /. The string fed to the path matcher does not include any text after
   * the first ? or #, and those chars are not allowed here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> paths;

  /**
   * In response to a matching path, the load balancer performs advanced routing actions, such as
   * URL rewrites and header transformations, before forwarding the request to the selected backend.
   * Only one of urlRedirect, service or routeAction.weightedBackendService can be set. URL maps for
   * classic Application Load Balancers only support the urlRewrite action within a path rule's
   * routeAction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpRouteAction routeAction;

  /**
   * The full or partial URL of the backend service resource to which traffic is directed if this
   * rule is matched. If routeAction is also specified, advanced routing actions, such as URL
   * rewrites, take effect before sending the request to the backend. Only one of urlRedirect,
   * service or routeAction.weightedBackendService can be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String service;

  /**
   * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect.
   * Only one of urlRedirect, service or routeAction.weightedBackendService can be set. Not
   * supported when the URL map is bound to a target gRPC proxy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpRedirectAction urlRedirect;

  /**
   * customErrorResponsePolicy specifies how the Load Balancer returns error responses when
   * BackendServiceor BackendBucket responds with an error. If a policy for an error code is not
   * configured for the PathRule, a policy for the error code configured in
   * pathMatcher.defaultCustomErrorResponsePolicy is applied. If one is not specified in
   * pathMatcher.defaultCustomErrorResponsePolicy, the policy configured in
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the
   * following configuration: - UrlMap.defaultCustomErrorResponsePolicy are configured with policies
   * for 5xx and 4xx errors - A PathRule for /coming_soon/ is configured for the error code 404. If
   * the request is for www.myotherdomain.com and a 404 is encountered, the policy under
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the
   * request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the
   * request for www.example.com/coming_soon/ encounters a 404, the policy in
   * PathRule.customErrorResponsePolicy takes effect. If any of the requests in this example
   * encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect.
   * customErrorResponsePolicy is supported only for global external Application Load Balancers.
   * @return value or {@code null} for none
   */
  public CustomErrorResponsePolicy getCustomErrorResponsePolicy() {
    return customErrorResponsePolicy;
  }

  /**
   * customErrorResponsePolicy specifies how the Load Balancer returns error responses when
   * BackendServiceor BackendBucket responds with an error. If a policy for an error code is not
   * configured for the PathRule, a policy for the error code configured in
   * pathMatcher.defaultCustomErrorResponsePolicy is applied. If one is not specified in
   * pathMatcher.defaultCustomErrorResponsePolicy, the policy configured in
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the
   * following configuration: - UrlMap.defaultCustomErrorResponsePolicy are configured with policies
   * for 5xx and 4xx errors - A PathRule for /coming_soon/ is configured for the error code 404. If
   * the request is for www.myotherdomain.com and a 404 is encountered, the policy under
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the
   * request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the
   * request for www.example.com/coming_soon/ encounters a 404, the policy in
   * PathRule.customErrorResponsePolicy takes effect. If any of the requests in this example
   * encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect.
   * customErrorResponsePolicy is supported only for global external Application Load Balancers.
   * @param customErrorResponsePolicy customErrorResponsePolicy or {@code null} for none
   */
  public PathRule setCustomErrorResponsePolicy(CustomErrorResponsePolicy customErrorResponsePolicy) {
    this.customErrorResponsePolicy = customErrorResponsePolicy;
    return this;
  }

  /**
   * The list of path patterns to match. Each must start with / and the only place a * is allowed is
   * at the end following a /. The string fed to the path matcher does not include any text after
   * the first ? or #, and those chars are not allowed here.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPaths() {
    return paths;
  }

  /**
   * The list of path patterns to match. Each must start with / and the only place a * is allowed is
   * at the end following a /. The string fed to the path matcher does not include any text after
   * the first ? or #, and those chars are not allowed here.
   * @param paths paths or {@code null} for none
   */
  public PathRule setPaths(java.util.List<java.lang.String> paths) {
    this.paths = paths;
    return this;
  }

  /**
   * In response to a matching path, the load balancer performs advanced routing actions, such as
   * URL rewrites and header transformations, before forwarding the request to the selected backend.
   * Only one of urlRedirect, service or routeAction.weightedBackendService can be set. URL maps for
   * classic Application Load Balancers only support the urlRewrite action within a path rule's
   * routeAction.
   * @return value or {@code null} for none
   */
  public HttpRouteAction getRouteAction() {
    return routeAction;
  }

  /**
   * In response to a matching path, the load balancer performs advanced routing actions, such as
   * URL rewrites and header transformations, before forwarding the request to the selected backend.
   * Only one of urlRedirect, service or routeAction.weightedBackendService can be set. URL maps for
   * classic Application Load Balancers only support the urlRewrite action within a path rule's
   * routeAction.
   * @param routeAction routeAction or {@code null} for none
   */
  public PathRule setRouteAction(HttpRouteAction routeAction) {
    this.routeAction = routeAction;
    return this;
  }

  /**
   * The full or partial URL of the backend service resource to which traffic is directed if this
   * rule is matched. If routeAction is also specified, advanced routing actions, such as URL
   * rewrites, take effect before sending the request to the backend. Only one of urlRedirect,
   * service or routeAction.weightedBackendService can be set.
   * @return value or {@code null} for none
   */
  public java.lang.String getService() {
    return service;
  }

  /**
   * The full or partial URL of the backend service resource to which traffic is directed if this
   * rule is matched. If routeAction is also specified, advanced routing actions, such as URL
   * rewrites, take effect before sending the request to the backend. Only one of urlRedirect,
   * service or routeAction.weightedBackendService can be set.
   * @param service service or {@code null} for none
   */
  public PathRule setService(java.lang.String service) {
    this.service = service;
    return this;
  }

  /**
   * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect.
   * Only one of urlRedirect, service or routeAction.weightedBackendService can be set. Not
   * supported when the URL map is bound to a target gRPC proxy.
   * @return value or {@code null} for none
   */
  public HttpRedirectAction getUrlRedirect() {
    return urlRedirect;
  }

  /**
   * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect.
   * Only one of urlRedirect, service or routeAction.weightedBackendService can be set. Not
   * supported when the URL map is bound to a target gRPC proxy.
   * @param urlRedirect urlRedirect or {@code null} for none
   */
  public PathRule setUrlRedirect(HttpRedirectAction urlRedirect) {
    this.urlRedirect = urlRedirect;
    return this;
  }

  @Override
  public PathRule set(String fieldName, Object value) {
    return (PathRule) super.set(fieldName, value);
  }

  @Override
  public PathRule clone() {
    return (PathRule) super.clone();
  }

}
