/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Custom constraint that specifies a key and a list of allowed values for Istio attributes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PermissionConstraint extends com.google.api.client.json.GenericJson {

  /**
   * Key of the constraint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * A list of allowed values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> values;

  /**
   * Key of the constraint.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * Key of the constraint.
   * @param key key or {@code null} for none
   */
  public PermissionConstraint setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * A list of allowed values.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getValues() {
    return values;
  }

  /**
   * A list of allowed values.
   * @param values values or {@code null} for none
   */
  public PermissionConstraint setValues(java.util.List<java.lang.String> values) {
    this.values = values;
    return this;
  }

  @Override
  public PermissionConstraint set(String fieldName, Object value) {
    return (PermissionConstraint) super.set(fieldName, value);
  }

  @Override
  public PermissionConstraint clone() {
    return (PermissionConstraint) super.clone();
  }

}
