/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for PreviewFeatureRolloutOperationRolloutInput.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PreviewFeatureRolloutOperationRolloutInput extends com.google.api.client.json.GenericJson {

  /**
   * The name of the rollout plan Ex. organizations//locations/global/rolloutPlans/ Ex.
   * folders//locations/global/rolloutPlans/ Ex. projects//locations/global/rolloutPlans/.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Predefined rollout plan.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String predefinedRolloutPlan;

  /**
   * The UUID of the retry action. Only needed if this is a retry for an existing rollout. This can
   * be used after the user canceled a rollout and want to retry it with no changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String retryUuid;

  /**
   * The name of the rollout plan Ex. organizations//locations/global/rolloutPlans/ Ex.
   * folders//locations/global/rolloutPlans/ Ex. projects//locations/global/rolloutPlans/.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the rollout plan Ex. organizations//locations/global/rolloutPlans/ Ex.
   * folders//locations/global/rolloutPlans/ Ex. projects//locations/global/rolloutPlans/.
   * @param name name or {@code null} for none
   */
  public PreviewFeatureRolloutOperationRolloutInput setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Predefined rollout plan.
   * @return value or {@code null} for none
   */
  public java.lang.String getPredefinedRolloutPlan() {
    return predefinedRolloutPlan;
  }

  /**
   * Predefined rollout plan.
   * @param predefinedRolloutPlan predefinedRolloutPlan or {@code null} for none
   */
  public PreviewFeatureRolloutOperationRolloutInput setPredefinedRolloutPlan(java.lang.String predefinedRolloutPlan) {
    this.predefinedRolloutPlan = predefinedRolloutPlan;
    return this;
  }

  /**
   * The UUID of the retry action. Only needed if this is a retry for an existing rollout. This can
   * be used after the user canceled a rollout and want to retry it with no changes.
   * @return value or {@code null} for none
   */
  public java.lang.String getRetryUuid() {
    return retryUuid;
  }

  /**
   * The UUID of the retry action. Only needed if this is a retry for an existing rollout. This can
   * be used after the user canceled a rollout and want to retry it with no changes.
   * @param retryUuid retryUuid or {@code null} for none
   */
  public PreviewFeatureRolloutOperationRolloutInput setRetryUuid(java.lang.String retryUuid) {
    this.retryUuid = retryUuid;
    return this;
  }

  @Override
  public PreviewFeatureRolloutOperationRolloutInput set(String fieldName, Object value) {
    return (PreviewFeatureRolloutOperationRolloutInput) super.set(fieldName, value);
  }

  @Override
  public PreviewFeatureRolloutOperationRolloutInput clone() {
    return (PreviewFeatureRolloutOperationRolloutInput) super.clone();
  }

}
