/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for PreviewFeatureRolloutOperationRolloutStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PreviewFeatureRolloutOperationRolloutStatus extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The ongoing rollout resources. There can be multiple ongoing rollouts for a
   * resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata> ongoingRollouts;

  /**
   * Output only. The last completed rollout resource. This field will not be populated until the
   * first rollout is completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata previousRollout;

  /**
   * Output only. The ongoing rollout resources. There can be multiple ongoing rollouts for a
   * resource.
   * @return value or {@code null} for none
   */
  public java.util.List<PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata> getOngoingRollouts() {
    return ongoingRollouts;
  }

  /**
   * Output only. The ongoing rollout resources. There can be multiple ongoing rollouts for a
   * resource.
   * @param ongoingRollouts ongoingRollouts or {@code null} for none
   */
  public PreviewFeatureRolloutOperationRolloutStatus setOngoingRollouts(java.util.List<PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata> ongoingRollouts) {
    this.ongoingRollouts = ongoingRollouts;
    return this;
  }

  /**
   * Output only. The last completed rollout resource. This field will not be populated until the
   * first rollout is completed.
   * @return value or {@code null} for none
   */
  public PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata getPreviousRollout() {
    return previousRollout;
  }

  /**
   * Output only. The last completed rollout resource. This field will not be populated until the
   * first rollout is completed.
   * @param previousRollout previousRollout or {@code null} for none
   */
  public PreviewFeatureRolloutOperationRolloutStatus setPreviousRollout(PreviewFeatureRolloutOperationRolloutStatusRolloutMetadata previousRollout) {
    this.previousRollout = previousRollout;
    return this;
  }

  @Override
  public PreviewFeatureRolloutOperationRolloutStatus set(String fieldName, Object value) {
    return (PreviewFeatureRolloutOperationRolloutStatus) super.set(fieldName, value);
  }

  @Override
  public PreviewFeatureRolloutOperationRolloutStatus clone() {
    return (PreviewFeatureRolloutOperationRolloutStatus) super.clone();
  }

}
