/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for PreviewFeatureStatusReleaseStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PreviewFeatureStatusReleaseStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The stage of the feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stage;

  /**
   * Output only. The last date when a feature transitioned between ReleaseStatuses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date updateDate;

  /**
   * [Output Only] The stage of the feature.
   * @return value or {@code null} for none
   */
  public java.lang.String getStage() {
    return stage;
  }

  /**
   * [Output Only] The stage of the feature.
   * @param stage stage or {@code null} for none
   */
  public PreviewFeatureStatusReleaseStatus setStage(java.lang.String stage) {
    this.stage = stage;
    return this;
  }

  /**
   * Output only. The last date when a feature transitioned between ReleaseStatuses.
   * @return value or {@code null} for none
   */
  public Date getUpdateDate() {
    return updateDate;
  }

  /**
   * Output only. The last date when a feature transitioned between ReleaseStatuses.
   * @param updateDate updateDate or {@code null} for none
   */
  public PreviewFeatureStatusReleaseStatus setUpdateDate(Date updateDate) {
    this.updateDate = updateDate;
    return this;
  }

  @Override
  public PreviewFeatureStatusReleaseStatus set(String fieldName, Object value) {
    return (PreviewFeatureStatusReleaseStatus) super.set(fieldName, value);
  }

  @Override
  public PreviewFeatureStatusReleaseStatus clone() {
    return (PreviewFeatureStatusReleaseStatus) super.clone();
  }

}
