/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ReplicationDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplicationDetails extends com.google.api.client.json.GenericJson {

  /**
   * The last sync time of the device pair.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastReplicationTime;

  /**
   * Replication lag in seconds. This will only be populated if device is in replicating state. Note
   * that the value is calculated sometime during request processing and at the instant the client
   * receives the response, the current replication_lag may have changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long secondsSinceLastReplication;

  /**
   * The last sync time of the device pair.
   * @return value or {@code null} for none
   */
  public String getLastReplicationTime() {
    return lastReplicationTime;
  }

  /**
   * The last sync time of the device pair.
   * @param lastReplicationTime lastReplicationTime or {@code null} for none
   */
  public ReplicationDetails setLastReplicationTime(String lastReplicationTime) {
    this.lastReplicationTime = lastReplicationTime;
    return this;
  }

  /**
   * Replication lag in seconds. This will only be populated if device is in replicating state. Note
   * that the value is calculated sometime during request processing and at the instant the client
   * receives the response, the current replication_lag may have changed.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSecondsSinceLastReplication() {
    return secondsSinceLastReplication;
  }

  /**
   * Replication lag in seconds. This will only be populated if device is in replicating state. Note
   * that the value is calculated sometime during request processing and at the instant the client
   * receives the response, the current replication_lag may have changed.
   * @param secondsSinceLastReplication secondsSinceLastReplication or {@code null} for none
   */
  public ReplicationDetails setSecondsSinceLastReplication(java.lang.Long secondsSinceLastReplication) {
    this.secondsSinceLastReplication = secondsSinceLastReplication;
    return this;
  }

  @Override
  public ReplicationDetails set(String fieldName, Object value) {
    return (ReplicationDetails) super.set(fieldName, value);
  }

  @Override
  public ReplicationDetails clone() {
    return (ReplicationDetails) super.clone();
  }

}
