/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Details about a risk.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RiskDetails extends com.google.api.client.json.GenericJson {

  /**
   * The duration of the risk since it was detected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String duration;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RiskDetailsGlobalDnsInsight globalDnsInsight;

  /**
   * The last time the risk was updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastUpdateTimestamp;

  /**
   * The severity of the risk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String severity;

  /**
   * The type of risk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The duration of the risk since it was detected.
   * @return value or {@code null} for none
   */
  public String getDuration() {
    return duration;
  }

  /**
   * The duration of the risk since it was detected.
   * @param duration duration or {@code null} for none
   */
  public RiskDetails setDuration(String duration) {
    this.duration = duration;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public RiskDetailsGlobalDnsInsight getGlobalDnsInsight() {
    return globalDnsInsight;
  }

  /**
   * @param globalDnsInsight globalDnsInsight or {@code null} for none
   */
  public RiskDetails setGlobalDnsInsight(RiskDetailsGlobalDnsInsight globalDnsInsight) {
    this.globalDnsInsight = globalDnsInsight;
    return this;
  }

  /**
   * The last time the risk was updated.
   * @return value or {@code null} for none
   */
  public String getLastUpdateTimestamp() {
    return lastUpdateTimestamp;
  }

  /**
   * The last time the risk was updated.
   * @param lastUpdateTimestamp lastUpdateTimestamp or {@code null} for none
   */
  public RiskDetails setLastUpdateTimestamp(String lastUpdateTimestamp) {
    this.lastUpdateTimestamp = lastUpdateTimestamp;
    return this;
  }

  /**
   * The severity of the risk.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeverity() {
    return severity;
  }

  /**
   * The severity of the risk.
   * @param severity severity or {@code null} for none
   */
  public RiskDetails setSeverity(java.lang.String severity) {
    this.severity = severity;
    return this;
  }

  /**
   * The type of risk.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of risk.
   * @param type type or {@code null} for none
   */
  public RiskDetails setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public RiskDetails set(String fieldName, Object value) {
    return (RiskDetails) super.set(fieldName, value);
  }

  @Override
  public RiskDetails clone() {
    return (RiskDetails) super.clone();
  }

}
