/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Defines the behaviour for instances with the instance_termination_action STOP.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SchedulingOnInstanceStopAction extends com.google.api.client.json.GenericJson {

  /**
   * If true, the contents of any attached Local SSD disks will be discarded else, the Local SSD
   * data will be preserved when the instance is stopped at the end of the run duration/termination
   * time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean discardLocalSsd;

  /**
   * If true, the contents of any attached Local SSD disks will be discarded else, the Local SSD
   * data will be preserved when the instance is stopped at the end of the run duration/termination
   * time.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDiscardLocalSsd() {
    return discardLocalSsd;
  }

  /**
   * If true, the contents of any attached Local SSD disks will be discarded else, the Local SSD
   * data will be preserved when the instance is stopped at the end of the run duration/termination
   * time.
   * @param discardLocalSsd discardLocalSsd or {@code null} for none
   */
  public SchedulingOnInstanceStopAction setDiscardLocalSsd(java.lang.Boolean discardLocalSsd) {
    this.discardLocalSsd = discardLocalSsd;
    return this;
  }

  @Override
  public SchedulingOnInstanceStopAction set(String fieldName, Object value) {
    return (SchedulingOnInstanceStopAction) super.set(fieldName, value);
  }

  @Override
  public SchedulingOnInstanceStopAction clone() {
    return (SchedulingOnInstanceStopAction) super.clone();
  }

}
