/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SnapshotGroupParameters.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SnapshotGroupParameters extends com.google.api.client.json.GenericJson {

  /**
   * URLs of the zones where disks should be replicated to. Only applicable for regional resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> replicaZones;

  /**
   * The source snapshot group used to create disks. You can provide this as a partial or full URL
   * to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project /global/snapshotGroups/snapshotGroup -
   * projects/project/global/snapshotGroups/snapshotGroup - global/snapshotGroups/snapshotGroup
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceSnapshotGroup;

  /**
   * URL of the disk type resource describing which disk type to use to create disks. Provide this
   * when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See
   * Persistent disk types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * URLs of the zones where disks should be replicated to. Only applicable for regional resources.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getReplicaZones() {
    return replicaZones;
  }

  /**
   * URLs of the zones where disks should be replicated to. Only applicable for regional resources.
   * @param replicaZones replicaZones or {@code null} for none
   */
  public SnapshotGroupParameters setReplicaZones(java.util.List<java.lang.String> replicaZones) {
    this.replicaZones = replicaZones;
    return this;
  }

  /**
   * The source snapshot group used to create disks. You can provide this as a partial or full URL
   * to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project /global/snapshotGroups/snapshotGroup -
   * projects/project/global/snapshotGroups/snapshotGroup - global/snapshotGroups/snapshotGroup
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceSnapshotGroup() {
    return sourceSnapshotGroup;
  }

  /**
   * The source snapshot group used to create disks. You can provide this as a partial or full URL
   * to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project /global/snapshotGroups/snapshotGroup -
   * projects/project/global/snapshotGroups/snapshotGroup - global/snapshotGroups/snapshotGroup
   * @param sourceSnapshotGroup sourceSnapshotGroup or {@code null} for none
   */
  public SnapshotGroupParameters setSourceSnapshotGroup(java.lang.String sourceSnapshotGroup) {
    this.sourceSnapshotGroup = sourceSnapshotGroup;
    return this;
  }

  /**
   * URL of the disk type resource describing which disk type to use to create disks. Provide this
   * when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See
   * Persistent disk types.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * URL of the disk type resource describing which disk type to use to create disks. Provide this
   * when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See
   * Persistent disk types.
   * @param type type or {@code null} for none
   */
  public SnapshotGroupParameters setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public SnapshotGroupParameters set(String fieldName, Object value) {
    return (SnapshotGroupParameters) super.set(fieldName, value);
  }

  @Override
  public SnapshotGroupParameters clone() {
    return (SnapshotGroupParameters) super.clone();
  }

}
