/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SnapshotSettingsAccessLocation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SnapshotSettingsAccessLocation extends com.google.api.client.json.GenericJson {

  /**
   * List of regions that can restore a regional snapshot from the current region
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SnapshotSettingsAccessLocationAccessLocationPreference> locations;

  /**
   * Policy of which location is allowed to access snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String policy;

  /**
   * List of regions that can restore a regional snapshot from the current region
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SnapshotSettingsAccessLocationAccessLocationPreference> getLocations() {
    return locations;
  }

  /**
   * List of regions that can restore a regional snapshot from the current region
   * @param locations locations or {@code null} for none
   */
  public SnapshotSettingsAccessLocation setLocations(java.util.Map<String, SnapshotSettingsAccessLocationAccessLocationPreference> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * Policy of which location is allowed to access snapshot.
   * @return value or {@code null} for none
   */
  public java.lang.String getPolicy() {
    return policy;
  }

  /**
   * Policy of which location is allowed to access snapshot.
   * @param policy policy or {@code null} for none
   */
  public SnapshotSettingsAccessLocation setPolicy(java.lang.String policy) {
    this.policy = policy;
    return this;
  }

  @Override
  public SnapshotSettingsAccessLocation set(String fieldName, Object value) {
    return (SnapshotSettingsAccessLocation) super.set(fieldName, value);
  }

  @Override
  public SnapshotSettingsAccessLocation clone() {
    return (SnapshotSettingsAccessLocation) super.clone();
  }

}
