/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Subnetwork resource. A subnetwork (also known as a subnet) is a logical partition of
 * a Virtual Private Cloud network with one primary IP range and zero or more secondary IP ranges.
 * For more information, read Virtual Private Cloud (VPC) Network.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Subnetwork extends com.google.api.client.json.GenericJson {

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Sets the aggregation
   * interval for collecting flow logs. Increasing the interval time reduces the amount of generated
   * flow logs for long-lasting connections. Default is an interval of 5 seconds per connection.
   * Valid values: INTERVAL_5_SEC, INTERVAL_30_SEC, INTERVAL_1_MIN, INTERVAL_5_MIN, INTERVAL_10_MIN,
   * INTERVAL_15_MIN.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String aggregationInterval;

  /**
   * Whether this subnetwork's ranges can conflict with existing static routes. Setting this to true
   * allows this subnetwork's primary and secondary ranges to overlap with (and contain) static
   * routes that have already been configured on the corresponding network. For example if a static
   * route has range 10.1.0.0/16, a subnet range 10.0.0.0/8 could only be created if
   * allow_conflicting_routes=true. Overlapping is only allowed on subnetwork operations; routes
   * whose ranges conflict with this subnetwork's ranges won't be allowed unless
   * route.allow_conflicting_subnetworks is set to true. Typically packets destined to IPs within
   * the subnetwork (which may contain private/sensitive data) are prevented from leaving the
   * virtual network. Setting this field to true will disable this feature. The default value is
   * false and applies to all existing subnetworks and automatically created subnetworks. This field
   * cannot be set to true at resource creation time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowSubnetCidrRoutesOverlap;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * This field can be set only at resource creation time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it
   * will not appear in get listings. If not set the default behavior is determined by the org
   * policy, if there is no org policy specified, then it will default to disabled. This field isn't
   * supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableFlowLogs;

  /**
   * Enables Layer2 communication on the subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableL2;

  /**
   * Deprecated in favor of enable in PrivateIpv6GoogleAccess. Whether the VMs in this subnet can
   * directly access Google services via internal IPv6 addresses. This field can be both set at
   * resource creation time and updated using patch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enablePrivateV6Access;

  /**
   * The external IPv6 address range that is owned by this subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalIpv6Prefix;

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date
   * fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail
   * with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve
   * a Subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the
   * field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0
   * means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless
   * otherwise specified by the org policy, which means half of all collected logs are reported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float flowSampling;

  /**
   * [Output Only] The gateway address for default routes to reach destination addresses outside
   * this subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gatewayAddress;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * The internal IPv6 address range that is owned by this subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalIpv6Prefix;

  /**
   * The range of internal addresses that are owned by this subnetwork. Provide this property when
   * you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and
   * non-overlapping within a network. Only IPv4 is supported. This field is set at resource
   * creation time. The range can be any range listed in the Valid ranges list. The range can be
   * expanded after creation using expandIpCidrRange.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipCidrRange;

  /**
   * Reference to the source of IP, like a PublicDelegatedPrefix (PDP) for BYOIP. The PDP must be a
   * sub-PDP in EXTERNAL_IPV6_SUBNETWORK_CREATION mode. Use one of the following formats to specify
   * a sub-PDP when creating a dual stack subnetwork with external access using BYOIP: - Full
   * resource URL, as in https://www.googleapis.com/compute/v1/projects/projectId/regions/region
   * /publicDelegatedPrefixes/sub-pdp-name - Partial URL, as in -
   * projects/projectId/regions/region/publicDelegatedPrefixes/ sub-pdp-name -
   * regions/region/publicDelegatedPrefixes/sub-pdp-name
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipCollection;

  /**
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified
   * during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipv6AccessType;

  /**
   * [Output Only] This field is for internal use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipv6CidrRange;

  /**
   * [Output Only] Possible endpoints of this subnetwork. It can be one of the following: - VM_ONLY:
   * The subnetwork can be used for creating instances and IPv6 addresses with VM endpoint type.
   * Such a subnetwork gets external IPv6 ranges from a public delegated prefix and cannot be used
   * to create NetLb. - VM_AND_FR: The subnetwork can be used for creating both VM instances and
   * Forwarding Rules. It can also be used to reserve IPv6 addresses with both VM and FR endpoint
   * types. Such a subnetwork gets its IPv6 range from Google IP Pool directly.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipv6GceEndpoint;

  /**
   * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled,
   * logs are exported to Cloud Logging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubnetworkLogConfig logConfig;

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Configures whether
   * metadata fields should be added to the reported VPC flow logs. Options are
   * INCLUDE_ALL_METADATA, EXCLUDE_ALL_METADATA, and CUSTOM_METADATA. Default is
   * EXCLUDE_ALL_METADATA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metadata;

  /**
   * The name of the resource, provided by the client when initially creating the resource. The name
   * must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63
   * characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the
   * first character must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The URL of the network to which this subnetwork belongs, provided by the client when initially
   * creating the subnetwork. This field can be set only at resource creation time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part
   * of resource payload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubnetworkParams params;

  /**
   * Whether the VMs in this subnet can access Google services without assigned external IP
   * addresses. This field can be both set at resource creation time and updated using
   * setPrivateIpGoogleAccess.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean privateIpGoogleAccess;

  /**
   * This field is for internal use. This field can be both set at resource creation time and
   * updated using patch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateIpv6GoogleAccess;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String purpose;

  /**
   * URL of the region where the Subnetwork resides. This field can be set only at resource creation
   * time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * The URL of the reserved internal range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reservedInternalRange;

  /**
   * The role of subnetwork. Currently, this field is only used when purpose is set to
   * GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An
   * ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a
   * region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently
   * draining. This field can be updated with a patch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * An array of configurations for secondary IP ranges for VM instances contained in this
   * subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork.
   * The alias IPs may belong to either primary or secondary ranges. This field can be updated with
   * a patch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SubnetworkSecondaryRange> secondaryIpRanges;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4
   * addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6
   * addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation
   * time and updated using patch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stackType;

  /**
   * [Output Only] The state of the subnetwork, which can be one of the following values: READY:
   * Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the
   * purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer
   * are being drained. A subnetwork that is draining cannot be used or modified until it reaches a
   * status of READY
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. [Output Only] The current IP utilization of all subnetwork ranges. Contains the
   * total number of allocated and free IPs in each range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubnetworkUtilizationDetails utilizationDetails;

  /**
   * A repeated field indicating the VLAN IDs supported on this subnetwork. During Subnet creation,
   * specifying vlan is valid only if enable_l2 is true. During Subnet Update, specifying vlan is
   * allowed only for l2 enabled subnets. Restricted to only one VLAN.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Integer> vlans;

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Sets the aggregation
   * interval for collecting flow logs. Increasing the interval time reduces the amount of generated
   * flow logs for long-lasting connections. Default is an interval of 5 seconds per connection.
   * Valid values: INTERVAL_5_SEC, INTERVAL_30_SEC, INTERVAL_1_MIN, INTERVAL_5_MIN, INTERVAL_10_MIN,
   * INTERVAL_15_MIN.
   * @return value or {@code null} for none
   */
  public java.lang.String getAggregationInterval() {
    return aggregationInterval;
  }

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Sets the aggregation
   * interval for collecting flow logs. Increasing the interval time reduces the amount of generated
   * flow logs for long-lasting connections. Default is an interval of 5 seconds per connection.
   * Valid values: INTERVAL_5_SEC, INTERVAL_30_SEC, INTERVAL_1_MIN, INTERVAL_5_MIN, INTERVAL_10_MIN,
   * INTERVAL_15_MIN.
   * @param aggregationInterval aggregationInterval or {@code null} for none
   */
  public Subnetwork setAggregationInterval(java.lang.String aggregationInterval) {
    this.aggregationInterval = aggregationInterval;
    return this;
  }

  /**
   * Whether this subnetwork's ranges can conflict with existing static routes. Setting this to true
   * allows this subnetwork's primary and secondary ranges to overlap with (and contain) static
   * routes that have already been configured on the corresponding network. For example if a static
   * route has range 10.1.0.0/16, a subnet range 10.0.0.0/8 could only be created if
   * allow_conflicting_routes=true. Overlapping is only allowed on subnetwork operations; routes
   * whose ranges conflict with this subnetwork's ranges won't be allowed unless
   * route.allow_conflicting_subnetworks is set to true. Typically packets destined to IPs within
   * the subnetwork (which may contain private/sensitive data) are prevented from leaving the
   * virtual network. Setting this field to true will disable this feature. The default value is
   * false and applies to all existing subnetworks and automatically created subnetworks. This field
   * cannot be set to true at resource creation time.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowSubnetCidrRoutesOverlap() {
    return allowSubnetCidrRoutesOverlap;
  }

  /**
   * Whether this subnetwork's ranges can conflict with existing static routes. Setting this to true
   * allows this subnetwork's primary and secondary ranges to overlap with (and contain) static
   * routes that have already been configured on the corresponding network. For example if a static
   * route has range 10.1.0.0/16, a subnet range 10.0.0.0/8 could only be created if
   * allow_conflicting_routes=true. Overlapping is only allowed on subnetwork operations; routes
   * whose ranges conflict with this subnetwork's ranges won't be allowed unless
   * route.allow_conflicting_subnetworks is set to true. Typically packets destined to IPs within
   * the subnetwork (which may contain private/sensitive data) are prevented from leaving the
   * virtual network. Setting this field to true will disable this feature. The default value is
   * false and applies to all existing subnetworks and automatically created subnetworks. This field
   * cannot be set to true at resource creation time.
   * @param allowSubnetCidrRoutesOverlap allowSubnetCidrRoutesOverlap or {@code null} for none
   */
  public Subnetwork setAllowSubnetCidrRoutesOverlap(java.lang.Boolean allowSubnetCidrRoutesOverlap) {
    this.allowSubnetCidrRoutesOverlap = allowSubnetCidrRoutesOverlap;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Subnetwork setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * This field can be set only at resource creation time.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * This field can be set only at resource creation time.
   * @param description description or {@code null} for none
   */
  public Subnetwork setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it
   * will not appear in get listings. If not set the default behavior is determined by the org
   * policy, if there is no org policy specified, then it will default to disabled. This field isn't
   * supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableFlowLogs() {
    return enableFlowLogs;
  }

  /**
   * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it
   * will not appear in get listings. If not set the default behavior is determined by the org
   * policy, if there is no org policy specified, then it will default to disabled. This field isn't
   * supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
   * @param enableFlowLogs enableFlowLogs or {@code null} for none
   */
  public Subnetwork setEnableFlowLogs(java.lang.Boolean enableFlowLogs) {
    this.enableFlowLogs = enableFlowLogs;
    return this;
  }

  /**
   * Enables Layer2 communication on the subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableL2() {
    return enableL2;
  }

  /**
   * Enables Layer2 communication on the subnetwork.
   * @param enableL2 enableL2 or {@code null} for none
   */
  public Subnetwork setEnableL2(java.lang.Boolean enableL2) {
    this.enableL2 = enableL2;
    return this;
  }

  /**
   * Deprecated in favor of enable in PrivateIpv6GoogleAccess. Whether the VMs in this subnet can
   * directly access Google services via internal IPv6 addresses. This field can be both set at
   * resource creation time and updated using patch.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnablePrivateV6Access() {
    return enablePrivateV6Access;
  }

  /**
   * Deprecated in favor of enable in PrivateIpv6GoogleAccess. Whether the VMs in this subnet can
   * directly access Google services via internal IPv6 addresses. This field can be both set at
   * resource creation time and updated using patch.
   * @param enablePrivateV6Access enablePrivateV6Access or {@code null} for none
   */
  public Subnetwork setEnablePrivateV6Access(java.lang.Boolean enablePrivateV6Access) {
    this.enablePrivateV6Access = enablePrivateV6Access;
    return this;
  }

  /**
   * The external IPv6 address range that is owned by this subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalIpv6Prefix() {
    return externalIpv6Prefix;
  }

  /**
   * The external IPv6 address range that is owned by this subnetwork.
   * @param externalIpv6Prefix externalIpv6Prefix or {@code null} for none
   */
  public Subnetwork setExternalIpv6Prefix(java.lang.String externalIpv6Prefix) {
    this.externalIpv6Prefix = externalIpv6Prefix;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date
   * fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail
   * with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve
   * a Subnetwork.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date
   * fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail
   * with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve
   * a Subnetwork.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date
   * fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail
   * with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve
   * a Subnetwork.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public Subnetwork setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a Subnetwork. An up-to-date
   * fingerprint must be provided in order to update the Subnetwork, otherwise the request will fail
   * with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve
   * a Subnetwork.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Subnetwork encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the
   * field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0
   * means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless
   * otherwise specified by the org policy, which means half of all collected logs are reported.
   * @return value or {@code null} for none
   */
  public java.lang.Float getFlowSampling() {
    return flowSampling;
  }

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the
   * field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0
   * means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless
   * otherwise specified by the org policy, which means half of all collected logs are reported.
   * @param flowSampling flowSampling or {@code null} for none
   */
  public Subnetwork setFlowSampling(java.lang.Float flowSampling) {
    this.flowSampling = flowSampling;
    return this;
  }

  /**
   * [Output Only] The gateway address for default routes to reach destination addresses outside
   * this subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getGatewayAddress() {
    return gatewayAddress;
  }

  /**
   * [Output Only] The gateway address for default routes to reach destination addresses outside
   * this subnetwork.
   * @param gatewayAddress gatewayAddress or {@code null} for none
   */
  public Subnetwork setGatewayAddress(java.lang.String gatewayAddress) {
    this.gatewayAddress = gatewayAddress;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public Subnetwork setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * The internal IPv6 address range that is owned by this subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalIpv6Prefix() {
    return internalIpv6Prefix;
  }

  /**
   * The internal IPv6 address range that is owned by this subnetwork.
   * @param internalIpv6Prefix internalIpv6Prefix or {@code null} for none
   */
  public Subnetwork setInternalIpv6Prefix(java.lang.String internalIpv6Prefix) {
    this.internalIpv6Prefix = internalIpv6Prefix;
    return this;
  }

  /**
   * The range of internal addresses that are owned by this subnetwork. Provide this property when
   * you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and
   * non-overlapping within a network. Only IPv4 is supported. This field is set at resource
   * creation time. The range can be any range listed in the Valid ranges list. The range can be
   * expanded after creation using expandIpCidrRange.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpCidrRange() {
    return ipCidrRange;
  }

  /**
   * The range of internal addresses that are owned by this subnetwork. Provide this property when
   * you create the subnetwork. For example, 10.0.0.0/8 or 100.64.0.0/10. Ranges must be unique and
   * non-overlapping within a network. Only IPv4 is supported. This field is set at resource
   * creation time. The range can be any range listed in the Valid ranges list. The range can be
   * expanded after creation using expandIpCidrRange.
   * @param ipCidrRange ipCidrRange or {@code null} for none
   */
  public Subnetwork setIpCidrRange(java.lang.String ipCidrRange) {
    this.ipCidrRange = ipCidrRange;
    return this;
  }

  /**
   * Reference to the source of IP, like a PublicDelegatedPrefix (PDP) for BYOIP. The PDP must be a
   * sub-PDP in EXTERNAL_IPV6_SUBNETWORK_CREATION mode. Use one of the following formats to specify
   * a sub-PDP when creating a dual stack subnetwork with external access using BYOIP: - Full
   * resource URL, as in https://www.googleapis.com/compute/v1/projects/projectId/regions/region
   * /publicDelegatedPrefixes/sub-pdp-name - Partial URL, as in -
   * projects/projectId/regions/region/publicDelegatedPrefixes/ sub-pdp-name -
   * regions/region/publicDelegatedPrefixes/sub-pdp-name
   * @return value or {@code null} for none
   */
  public java.lang.String getIpCollection() {
    return ipCollection;
  }

  /**
   * Reference to the source of IP, like a PublicDelegatedPrefix (PDP) for BYOIP. The PDP must be a
   * sub-PDP in EXTERNAL_IPV6_SUBNETWORK_CREATION mode. Use one of the following formats to specify
   * a sub-PDP when creating a dual stack subnetwork with external access using BYOIP: - Full
   * resource URL, as in https://www.googleapis.com/compute/v1/projects/projectId/regions/region
   * /publicDelegatedPrefixes/sub-pdp-name - Partial URL, as in -
   * projects/projectId/regions/region/publicDelegatedPrefixes/ sub-pdp-name -
   * regions/region/publicDelegatedPrefixes/sub-pdp-name
   * @param ipCollection ipCollection or {@code null} for none
   */
  public Subnetwork setIpCollection(java.lang.String ipCollection) {
    this.ipCollection = ipCollection;
    return this;
  }

  /**
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified
   * during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpv6AccessType() {
    return ipv6AccessType;
  }

  /**
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified
   * during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * @param ipv6AccessType ipv6AccessType or {@code null} for none
   */
  public Subnetwork setIpv6AccessType(java.lang.String ipv6AccessType) {
    this.ipv6AccessType = ipv6AccessType;
    return this;
  }

  /**
   * [Output Only] This field is for internal use.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpv6CidrRange() {
    return ipv6CidrRange;
  }

  /**
   * [Output Only] This field is for internal use.
   * @param ipv6CidrRange ipv6CidrRange or {@code null} for none
   */
  public Subnetwork setIpv6CidrRange(java.lang.String ipv6CidrRange) {
    this.ipv6CidrRange = ipv6CidrRange;
    return this;
  }

  /**
   * [Output Only] Possible endpoints of this subnetwork. It can be one of the following: - VM_ONLY:
   * The subnetwork can be used for creating instances and IPv6 addresses with VM endpoint type.
   * Such a subnetwork gets external IPv6 ranges from a public delegated prefix and cannot be used
   * to create NetLb. - VM_AND_FR: The subnetwork can be used for creating both VM instances and
   * Forwarding Rules. It can also be used to reserve IPv6 addresses with both VM and FR endpoint
   * types. Such a subnetwork gets its IPv6 range from Google IP Pool directly.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpv6GceEndpoint() {
    return ipv6GceEndpoint;
  }

  /**
   * [Output Only] Possible endpoints of this subnetwork. It can be one of the following: - VM_ONLY:
   * The subnetwork can be used for creating instances and IPv6 addresses with VM endpoint type.
   * Such a subnetwork gets external IPv6 ranges from a public delegated prefix and cannot be used
   * to create NetLb. - VM_AND_FR: The subnetwork can be used for creating both VM instances and
   * Forwarding Rules. It can also be used to reserve IPv6 addresses with both VM and FR endpoint
   * types. Such a subnetwork gets its IPv6 range from Google IP Pool directly.
   * @param ipv6GceEndpoint ipv6GceEndpoint or {@code null} for none
   */
  public Subnetwork setIpv6GceEndpoint(java.lang.String ipv6GceEndpoint) {
    this.ipv6GceEndpoint = ipv6GceEndpoint;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#subnetwork for Subnetwork resources.
   * @param kind kind or {@code null} for none
   */
  public Subnetwork setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled,
   * logs are exported to Cloud Logging.
   * @return value or {@code null} for none
   */
  public SubnetworkLogConfig getLogConfig() {
    return logConfig;
  }

  /**
   * This field denotes the VPC flow logging options for this subnetwork. If logging is enabled,
   * logs are exported to Cloud Logging.
   * @param logConfig logConfig or {@code null} for none
   */
  public Subnetwork setLogConfig(SubnetworkLogConfig logConfig) {
    this.logConfig = logConfig;
    return this;
  }

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Configures whether
   * metadata fields should be added to the reported VPC flow logs. Options are
   * INCLUDE_ALL_METADATA, EXCLUDE_ALL_METADATA, and CUSTOM_METADATA. Default is
   * EXCLUDE_ALL_METADATA.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetadata() {
    return metadata;
  }

  /**
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Configures whether
   * metadata fields should be added to the reported VPC flow logs. Options are
   * INCLUDE_ALL_METADATA, EXCLUDE_ALL_METADATA, and CUSTOM_METADATA. Default is
   * EXCLUDE_ALL_METADATA.
   * @param metadata metadata or {@code null} for none
   */
  public Subnetwork setMetadata(java.lang.String metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The name of the resource, provided by the client when initially creating the resource. The name
   * must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63
   * characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the
   * first character must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the resource, provided by the client when initially creating the resource. The name
   * must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63
   * characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the
   * first character must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public Subnetwork setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The URL of the network to which this subnetwork belongs, provided by the client when initially
   * creating the subnetwork. This field can be set only at resource creation time.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * The URL of the network to which this subnetwork belongs, provided by the client when initially
   * creating the subnetwork. This field can be set only at resource creation time.
   * @param network network or {@code null} for none
   */
  public Subnetwork setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part
   * of resource payload.
   * @return value or {@code null} for none
   */
  public SubnetworkParams getParams() {
    return params;
  }

  /**
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part
   * of resource payload.
   * @param params params or {@code null} for none
   */
  public Subnetwork setParams(SubnetworkParams params) {
    this.params = params;
    return this;
  }

  /**
   * Whether the VMs in this subnet can access Google services without assigned external IP
   * addresses. This field can be both set at resource creation time and updated using
   * setPrivateIpGoogleAccess.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPrivateIpGoogleAccess() {
    return privateIpGoogleAccess;
  }

  /**
   * Whether the VMs in this subnet can access Google services without assigned external IP
   * addresses. This field can be both set at resource creation time and updated using
   * setPrivateIpGoogleAccess.
   * @param privateIpGoogleAccess privateIpGoogleAccess or {@code null} for none
   */
  public Subnetwork setPrivateIpGoogleAccess(java.lang.Boolean privateIpGoogleAccess) {
    this.privateIpGoogleAccess = privateIpGoogleAccess;
    return this;
  }

  /**
   * This field is for internal use. This field can be both set at resource creation time and
   * updated using patch.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateIpv6GoogleAccess() {
    return privateIpv6GoogleAccess;
  }

  /**
   * This field is for internal use. This field can be both set at resource creation time and
   * updated using patch.
   * @param privateIpv6GoogleAccess privateIpv6GoogleAccess or {@code null} for none
   */
  public Subnetwork setPrivateIpv6GoogleAccess(java.lang.String privateIpv6GoogleAccess) {
    this.privateIpv6GoogleAccess = privateIpv6GoogleAccess;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getPurpose() {
    return purpose;
  }

  /**
   * @param purpose purpose or {@code null} for none
   */
  public Subnetwork setPurpose(java.lang.String purpose) {
    this.purpose = purpose;
    return this;
  }

  /**
   * URL of the region where the Subnetwork resides. This field can be set only at resource creation
   * time.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * URL of the region where the Subnetwork resides. This field can be set only at resource creation
   * time.
   * @param region region or {@code null} for none
   */
  public Subnetwork setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * The URL of the reserved internal range.
   * @return value or {@code null} for none
   */
  public java.lang.String getReservedInternalRange() {
    return reservedInternalRange;
  }

  /**
   * The URL of the reserved internal range.
   * @param reservedInternalRange reservedInternalRange or {@code null} for none
   */
  public Subnetwork setReservedInternalRange(java.lang.String reservedInternalRange) {
    this.reservedInternalRange = reservedInternalRange;
    return this;
  }

  /**
   * The role of subnetwork. Currently, this field is only used when purpose is set to
   * GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An
   * ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a
   * region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently
   * draining. This field can be updated with a patch request.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The role of subnetwork. Currently, this field is only used when purpose is set to
   * GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An
   * ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a
   * region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently
   * draining. This field can be updated with a patch request.
   * @param role role or {@code null} for none
   */
  public Subnetwork setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * An array of configurations for secondary IP ranges for VM instances contained in this
   * subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork.
   * The alias IPs may belong to either primary or secondary ranges. This field can be updated with
   * a patch request.
   * @return value or {@code null} for none
   */
  public java.util.List<SubnetworkSecondaryRange> getSecondaryIpRanges() {
    return secondaryIpRanges;
  }

  /**
   * An array of configurations for secondary IP ranges for VM instances contained in this
   * subnetwork. The primary IP of such VM must belong to the primary ipCidrRange of the subnetwork.
   * The alias IPs may belong to either primary or secondary ranges. This field can be updated with
   * a patch request.
   * @param secondaryIpRanges secondaryIpRanges or {@code null} for none
   */
  public Subnetwork setSecondaryIpRanges(java.util.List<SubnetworkSecondaryRange> secondaryIpRanges) {
    this.secondaryIpRanges = secondaryIpRanges;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Subnetwork setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public Subnetwork setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4
   * addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6
   * addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation
   * time and updated using patch.
   * @return value or {@code null} for none
   */
  public java.lang.String getStackType() {
    return stackType;
  }

  /**
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4
   * addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6
   * addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation
   * time and updated using patch.
   * @param stackType stackType or {@code null} for none
   */
  public Subnetwork setStackType(java.lang.String stackType) {
    this.stackType = stackType;
    return this;
  }

  /**
   * [Output Only] The state of the subnetwork, which can be one of the following values: READY:
   * Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the
   * purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer
   * are being drained. A subnetwork that is draining cannot be used or modified until it reaches a
   * status of READY
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * [Output Only] The state of the subnetwork, which can be one of the following values: READY:
   * Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the
   * purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer
   * are being drained. A subnetwork that is draining cannot be used or modified until it reaches a
   * status of READY
   * @param state state or {@code null} for none
   */
  public Subnetwork setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Output only. [Output Only] The current IP utilization of all subnetwork ranges. Contains the
   * total number of allocated and free IPs in each range.
   * @return value or {@code null} for none
   */
  public SubnetworkUtilizationDetails getUtilizationDetails() {
    return utilizationDetails;
  }

  /**
   * Output only. [Output Only] The current IP utilization of all subnetwork ranges. Contains the
   * total number of allocated and free IPs in each range.
   * @param utilizationDetails utilizationDetails or {@code null} for none
   */
  public Subnetwork setUtilizationDetails(SubnetworkUtilizationDetails utilizationDetails) {
    this.utilizationDetails = utilizationDetails;
    return this;
  }

  /**
   * A repeated field indicating the VLAN IDs supported on this subnetwork. During Subnet creation,
   * specifying vlan is valid only if enable_l2 is true. During Subnet Update, specifying vlan is
   * allowed only for l2 enabled subnets. Restricted to only one VLAN.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Integer> getVlans() {
    return vlans;
  }

  /**
   * A repeated field indicating the VLAN IDs supported on this subnetwork. During Subnet creation,
   * specifying vlan is valid only if enable_l2 is true. During Subnet Update, specifying vlan is
   * allowed only for l2 enabled subnets. Restricted to only one VLAN.
   * @param vlans vlans or {@code null} for none
   */
  public Subnetwork setVlans(java.util.List<java.lang.Integer> vlans) {
    this.vlans = vlans;
    return this;
  }

  @Override
  public Subnetwork set(String fieldName, Object value) {
    return (Subnetwork) super.set(fieldName, value);
  }

  @Override
  public Subnetwork clone() {
    return (Subnetwork) super.clone();
  }

}
