/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Upcoming Maintenance notification information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpcomingMaintenance extends com.google.api.client.json.GenericJson {

  /**
   * Indicates if the maintenance can be customer triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canReschedule;

  /**
   * [Output Only] The date when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use window_start_time instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String date;

  /**
   * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339
   * text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String latestWindowStartTime;

  /**
   * Indicates whether the UpcomingMaintenance will be triggered on VM shutdown.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean maintenanceOnShutdown;

  /**
   * The reasons for the maintenance. Only valid for vms.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> maintenanceReasons;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maintenanceStatus;

  /**
   * [Output Only] The start time window of the maintenance disruption. DEPRECATED: Use
   * window_start_time instead. TimeWindow is a container for two strings that represent timestamps
   * in "yyyy-MM-dd'T'HH:mm:ssZ" text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpcomingMaintenanceTimeWindow startTimeWindow;

  /**
   * [Output Only] The time when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use window_start_time instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String time;

  /**
   * Defines the type of maintenance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The time by which the maintenance disruption will be completed. This timestamp value is in
   * RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String windowEndTime;

  /**
   * The current start time of the maintenance window. This timestamp value is in RFC3339 text
   * format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String windowStartTime;

  /**
   * Indicates if the maintenance can be customer triggered.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanReschedule() {
    return canReschedule;
  }

  /**
   * Indicates if the maintenance can be customer triggered.
   * @param canReschedule canReschedule or {@code null} for none
   */
  public UpcomingMaintenance setCanReschedule(java.lang.Boolean canReschedule) {
    this.canReschedule = canReschedule;
    return this;
  }

  /**
   * [Output Only] The date when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use window_start_time instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getDate() {
    return date;
  }

  /**
   * [Output Only] The date when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use window_start_time instead.
   * @param date date or {@code null} for none
   */
  public UpcomingMaintenance setDate(java.lang.String date) {
    this.date = date;
    return this;
  }

  /**
   * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339
   * text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getLatestWindowStartTime() {
    return latestWindowStartTime;
  }

  /**
   * The latest time for the planned maintenance window to start. This timestamp value is in RFC3339
   * text format.
   * @param latestWindowStartTime latestWindowStartTime or {@code null} for none
   */
  public UpcomingMaintenance setLatestWindowStartTime(java.lang.String latestWindowStartTime) {
    this.latestWindowStartTime = latestWindowStartTime;
    return this;
  }

  /**
   * Indicates whether the UpcomingMaintenance will be triggered on VM shutdown.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMaintenanceOnShutdown() {
    return maintenanceOnShutdown;
  }

  /**
   * Indicates whether the UpcomingMaintenance will be triggered on VM shutdown.
   * @param maintenanceOnShutdown maintenanceOnShutdown or {@code null} for none
   */
  public UpcomingMaintenance setMaintenanceOnShutdown(java.lang.Boolean maintenanceOnShutdown) {
    this.maintenanceOnShutdown = maintenanceOnShutdown;
    return this;
  }

  /**
   * The reasons for the maintenance. Only valid for vms.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMaintenanceReasons() {
    return maintenanceReasons;
  }

  /**
   * The reasons for the maintenance. Only valid for vms.
   * @param maintenanceReasons maintenanceReasons or {@code null} for none
   */
  public UpcomingMaintenance setMaintenanceReasons(java.util.List<java.lang.String> maintenanceReasons) {
    this.maintenanceReasons = maintenanceReasons;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getMaintenanceStatus() {
    return maintenanceStatus;
  }

  /**
   * @param maintenanceStatus maintenanceStatus or {@code null} for none
   */
  public UpcomingMaintenance setMaintenanceStatus(java.lang.String maintenanceStatus) {
    this.maintenanceStatus = maintenanceStatus;
    return this;
  }

  /**
   * [Output Only] The start time window of the maintenance disruption. DEPRECATED: Use
   * window_start_time instead. TimeWindow is a container for two strings that represent timestamps
   * in "yyyy-MM-dd'T'HH:mm:ssZ" text format.
   * @return value or {@code null} for none
   */
  public UpcomingMaintenanceTimeWindow getStartTimeWindow() {
    return startTimeWindow;
  }

  /**
   * [Output Only] The start time window of the maintenance disruption. DEPRECATED: Use
   * window_start_time instead. TimeWindow is a container for two strings that represent timestamps
   * in "yyyy-MM-dd'T'HH:mm:ssZ" text format.
   * @param startTimeWindow startTimeWindow or {@code null} for none
   */
  public UpcomingMaintenance setStartTimeWindow(UpcomingMaintenanceTimeWindow startTimeWindow) {
    this.startTimeWindow = startTimeWindow;
    return this;
  }

  /**
   * [Output Only] The time when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use window_start_time instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getTime() {
    return time;
  }

  /**
   * [Output Only] The time when the maintenance will take place. This value is in RFC3339 text
   * format. DEPRECATED: Use window_start_time instead.
   * @param time time or {@code null} for none
   */
  public UpcomingMaintenance setTime(java.lang.String time) {
    this.time = time;
    return this;
  }

  /**
   * Defines the type of maintenance.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Defines the type of maintenance.
   * @param type type or {@code null} for none
   */
  public UpcomingMaintenance setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The time by which the maintenance disruption will be completed. This timestamp value is in
   * RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getWindowEndTime() {
    return windowEndTime;
  }

  /**
   * The time by which the maintenance disruption will be completed. This timestamp value is in
   * RFC3339 text format.
   * @param windowEndTime windowEndTime or {@code null} for none
   */
  public UpcomingMaintenance setWindowEndTime(java.lang.String windowEndTime) {
    this.windowEndTime = windowEndTime;
    return this;
  }

  /**
   * The current start time of the maintenance window. This timestamp value is in RFC3339 text
   * format.
   * @return value or {@code null} for none
   */
  public java.lang.String getWindowStartTime() {
    return windowStartTime;
  }

  /**
   * The current start time of the maintenance window. This timestamp value is in RFC3339 text
   * format.
   * @param windowStartTime windowStartTime or {@code null} for none
   */
  public UpcomingMaintenance setWindowStartTime(java.lang.String windowStartTime) {
    this.windowStartTime = windowStartTime;
    return this;
  }

  @Override
  public UpcomingMaintenance set(String fieldName, Object value) {
    return (UpcomingMaintenance) super.set(fieldName, value);
  }

  @Override
  public UpcomingMaintenance clone() {
    return (UpcomingMaintenance) super.clone();
  }

}
