/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A pseudowire that connects two Interconnect connections.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Wire extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Indicates whether the wire is enabled. When false, the wire is disabled. When
   * true and when the wire group of the wire is also enabled, the wire is enabled. Defaults to
   * true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adminEnabled;

  /**
   * Wire endpoints are specific Interconnect connections.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<WireEndpoint> endpoints;

  /**
   * [Output Only] A label that identifies the wire. The format of this label combines the existing
   * labels of the wire group endpoints and Interconnect connections used by this wire in
   * alphabetical order as follows: `ENDPOINT_A+CONNECTION_A1,ENDPOINT_B+CONNECTION_B1`, where: -
   * ENDPOINT_A and ENDPOINT_B: are the labels that you entered as map keys when you specified the
   * wire group endpoint objects. - CONNECTION_A1 and CONNECTION_B1: are the labels that you entered
   * as map keys when you specified the wire group Interconnect objects.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * [Output Only] Properties of the wire.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WireProperties wireProperties;

  /**
   * [Output Only] Indicates whether the wire is enabled. When false, the wire is disabled. When
   * true and when the wire group of the wire is also enabled, the wire is enabled. Defaults to
   * true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdminEnabled() {
    return adminEnabled;
  }

  /**
   * [Output Only] Indicates whether the wire is enabled. When false, the wire is disabled. When
   * true and when the wire group of the wire is also enabled, the wire is enabled. Defaults to
   * true.
   * @param adminEnabled adminEnabled or {@code null} for none
   */
  public Wire setAdminEnabled(java.lang.Boolean adminEnabled) {
    this.adminEnabled = adminEnabled;
    return this;
  }

  /**
   * Wire endpoints are specific Interconnect connections.
   * @return value or {@code null} for none
   */
  public java.util.List<WireEndpoint> getEndpoints() {
    return endpoints;
  }

  /**
   * Wire endpoints are specific Interconnect connections.
   * @param endpoints endpoints or {@code null} for none
   */
  public Wire setEndpoints(java.util.List<WireEndpoint> endpoints) {
    this.endpoints = endpoints;
    return this;
  }

  /**
   * [Output Only] A label that identifies the wire. The format of this label combines the existing
   * labels of the wire group endpoints and Interconnect connections used by this wire in
   * alphabetical order as follows: `ENDPOINT_A+CONNECTION_A1,ENDPOINT_B+CONNECTION_B1`, where: -
   * ENDPOINT_A and ENDPOINT_B: are the labels that you entered as map keys when you specified the
   * wire group endpoint objects. - CONNECTION_A1 and CONNECTION_B1: are the labels that you entered
   * as map keys when you specified the wire group Interconnect objects.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * [Output Only] A label that identifies the wire. The format of this label combines the existing
   * labels of the wire group endpoints and Interconnect connections used by this wire in
   * alphabetical order as follows: `ENDPOINT_A+CONNECTION_A1,ENDPOINT_B+CONNECTION_B1`, where: -
   * ENDPOINT_A and ENDPOINT_B: are the labels that you entered as map keys when you specified the
   * wire group endpoint objects. - CONNECTION_A1 and CONNECTION_B1: are the labels that you entered
   * as map keys when you specified the wire group Interconnect objects.
   * @param label label or {@code null} for none
   */
  public Wire setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * [Output Only] Properties of the wire.
   * @return value or {@code null} for none
   */
  public WireProperties getWireProperties() {
    return wireProperties;
  }

  /**
   * [Output Only] Properties of the wire.
   * @param wireProperties wireProperties or {@code null} for none
   */
  public Wire setWireProperties(WireProperties wireProperties) {
    this.wireProperties = wireProperties;
    return this;
  }

  @Override
  public Wire set(String fieldName, Object value) {
    return (Wire) super.set(fieldName, value);
  }

  @Override
  public Wire clone() {
    return (Wire) super.clone();
  }

}
