/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-10-19 at 03:24:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Custom utilization metric policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoscalingPolicyCustomMetricUtilization extends com.google.api.client.json.GenericJson {

  /**
   * The identifier of the Stackdriver Monitoring metric. The metric cannot have negative values and
   * should be a utilization metric, which means that the number of virtual machines handling
   * requests should increase or decrease proportionally to the metric. The metric must also have a
   * label of compute.googleapis.com/resource_id with the value of the instance's unique ID,
   * although this alone does not guarantee that the metric is valid.
   *
   * For example, the following is a valid metric:
   * compute.googleapis.com/instance/network/received_bytes_count The following is not a valid
   * metric because it does not increase or decrease based on usage:
   * compute.googleapis.com/instance/cpu/reserved_cores
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metric;

  /**
   * Target value of the metric which autoscaler should maintain. Must be a positive value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double utilizationTarget;

  /**
   * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either
   * GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE. If not specified, the default is GAUGE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String utilizationTargetType;

  /**
   * The identifier of the Stackdriver Monitoring metric. The metric cannot have negative values and
   * should be a utilization metric, which means that the number of virtual machines handling
   * requests should increase or decrease proportionally to the metric. The metric must also have a
   * label of compute.googleapis.com/resource_id with the value of the instance's unique ID,
   * although this alone does not guarantee that the metric is valid.
   *
   * For example, the following is a valid metric:
   * compute.googleapis.com/instance/network/received_bytes_count The following is not a valid
   * metric because it does not increase or decrease based on usage:
   * compute.googleapis.com/instance/cpu/reserved_cores
   * @return value or {@code null} for none
   */
  public java.lang.String getMetric() {
    return metric;
  }

  /**
   * The identifier of the Stackdriver Monitoring metric. The metric cannot have negative values and
   * should be a utilization metric, which means that the number of virtual machines handling
   * requests should increase or decrease proportionally to the metric. The metric must also have a
   * label of compute.googleapis.com/resource_id with the value of the instance's unique ID,
   * although this alone does not guarantee that the metric is valid.
   *
   * For example, the following is a valid metric:
   * compute.googleapis.com/instance/network/received_bytes_count The following is not a valid
   * metric because it does not increase or decrease based on usage:
   * compute.googleapis.com/instance/cpu/reserved_cores
   * @param metric metric or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setMetric(java.lang.String metric) {
    this.metric = metric;
    return this;
  }

  /**
   * Target value of the metric which autoscaler should maintain. Must be a positive value.
   * @return value or {@code null} for none
   */
  public java.lang.Double getUtilizationTarget() {
    return utilizationTarget;
  }

  /**
   * Target value of the metric which autoscaler should maintain. Must be a positive value.
   * @param utilizationTarget utilizationTarget or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setUtilizationTarget(java.lang.Double utilizationTarget) {
    this.utilizationTarget = utilizationTarget;
    return this;
  }

  /**
   * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either
   * GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE. If not specified, the default is GAUGE.
   * @return value or {@code null} for none
   */
  public java.lang.String getUtilizationTargetType() {
    return utilizationTargetType;
  }

  /**
   * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either
   * GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE. If not specified, the default is GAUGE.
   * @param utilizationTargetType utilizationTargetType or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setUtilizationTargetType(java.lang.String utilizationTargetType) {
    this.utilizationTargetType = utilizationTargetType;
    return this;
  }

  @Override
  public AutoscalingPolicyCustomMetricUtilization set(String fieldName, Object value) {
    return (AutoscalingPolicyCustomMetricUtilization) super.set(fieldName, value);
  }

  @Override
  public AutoscalingPolicyCustomMetricUtilization clone() {
    return (AutoscalingPolicyCustomMetricUtilization) super.clone();
  }

}
