/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-10-19 at 03:24:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for DiskMoveRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiskMoveRequest extends com.google.api.client.json.GenericJson {

  /**
   * The URL of the destination zone to move the disk. This can be a full or partial URL. For
   * example, the following are all valid URLs to a zone: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone  -
   * projects/project/zones/zone  - zones/zone
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationZone;

  /**
   * The URL of the target disk to move. This can be a full or partial URL. For example, the
   * following are all valid URLs to a disk: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk  -
   * projects/project/zones/zone/disks/disk  - zones/zone/disks/disk
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetDisk;

  /**
   * The URL of the destination zone to move the disk. This can be a full or partial URL. For
   * example, the following are all valid URLs to a zone: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone  -
   * projects/project/zones/zone  - zones/zone
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationZone() {
    return destinationZone;
  }

  /**
   * The URL of the destination zone to move the disk. This can be a full or partial URL. For
   * example, the following are all valid URLs to a zone: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone  -
   * projects/project/zones/zone  - zones/zone
   * @param destinationZone destinationZone or {@code null} for none
   */
  public DiskMoveRequest setDestinationZone(java.lang.String destinationZone) {
    this.destinationZone = destinationZone;
    return this;
  }

  /**
   * The URL of the target disk to move. This can be a full or partial URL. For example, the
   * following are all valid URLs to a disk: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk  -
   * projects/project/zones/zone/disks/disk  - zones/zone/disks/disk
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetDisk() {
    return targetDisk;
  }

  /**
   * The URL of the target disk to move. This can be a full or partial URL. For example, the
   * following are all valid URLs to a disk: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk  -
   * projects/project/zones/zone/disks/disk  - zones/zone/disks/disk
   * @param targetDisk targetDisk or {@code null} for none
   */
  public DiskMoveRequest setTargetDisk(java.lang.String targetDisk) {
    this.targetDisk = targetDisk;
    return this;
  }

  @Override
  public DiskMoveRequest set(String fieldName, Object value) {
    return (DiskMoveRequest) super.set(fieldName, value);
  }

  @Override
  public DiskMoveRequest clone() {
    return (DiskMoveRequest) super.clone();
  }

}
