/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-01-11 18:31:16 UTC)
 * on 2017-01-11 at 20:26:37 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerUpdatePolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerUpdatePolicy extends com.google.api.client.json.GenericJson {

  /**
   * Maximum number of instances that can be created above the InstanceGroupManager.targetSize
   * during the update process. By default, a fixed value of 1 is used. Using maxSurge > 0 will
   * cause instance names to change during the update process. At least one of { maxSurge,
   * maxUnavailable } must be greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FixedOrPercent maxSurge;

  /**
   * Maximum number of instances that can be unavailable during the update process. The instance is
   * considered available if all of the following conditions are satisfied: 1. instance's status is
   * RUNNING 2. instance's liveness health check result was observed to be HEALTHY at least once By
   * default, a fixed value of 1 is used. At least one of { maxSurge, maxUnavailable } must be
   * greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FixedOrPercent maxUnavailable;

  /**
   * Minimum number of seconds to wait for after a newly created instance becomes available. This
   * value must be from range [0, 3600].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minReadySec;

  /**
   * Minimal action to be taken on an instance. The order of action types is: RESTART < REPLACE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minimalAction;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Maximum number of instances that can be created above the InstanceGroupManager.targetSize
   * during the update process. By default, a fixed value of 1 is used. Using maxSurge > 0 will
   * cause instance names to change during the update process. At least one of { maxSurge,
   * maxUnavailable } must be greater than 0.
   * @return value or {@code null} for none
   */
  public FixedOrPercent getMaxSurge() {
    return maxSurge;
  }

  /**
   * Maximum number of instances that can be created above the InstanceGroupManager.targetSize
   * during the update process. By default, a fixed value of 1 is used. Using maxSurge > 0 will
   * cause instance names to change during the update process. At least one of { maxSurge,
   * maxUnavailable } must be greater than 0.
   * @param maxSurge maxSurge or {@code null} for none
   */
  public InstanceGroupManagerUpdatePolicy setMaxSurge(FixedOrPercent maxSurge) {
    this.maxSurge = maxSurge;
    return this;
  }

  /**
   * Maximum number of instances that can be unavailable during the update process. The instance is
   * considered available if all of the following conditions are satisfied: 1. instance's status is
   * RUNNING 2. instance's liveness health check result was observed to be HEALTHY at least once By
   * default, a fixed value of 1 is used. At least one of { maxSurge, maxUnavailable } must be
   * greater than 0.
   * @return value or {@code null} for none
   */
  public FixedOrPercent getMaxUnavailable() {
    return maxUnavailable;
  }

  /**
   * Maximum number of instances that can be unavailable during the update process. The instance is
   * considered available if all of the following conditions are satisfied: 1. instance's status is
   * RUNNING 2. instance's liveness health check result was observed to be HEALTHY at least once By
   * default, a fixed value of 1 is used. At least one of { maxSurge, maxUnavailable } must be
   * greater than 0.
   * @param maxUnavailable maxUnavailable or {@code null} for none
   */
  public InstanceGroupManagerUpdatePolicy setMaxUnavailable(FixedOrPercent maxUnavailable) {
    this.maxUnavailable = maxUnavailable;
    return this;
  }

  /**
   * Minimum number of seconds to wait for after a newly created instance becomes available. This
   * value must be from range [0, 3600].
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinReadySec() {
    return minReadySec;
  }

  /**
   * Minimum number of seconds to wait for after a newly created instance becomes available. This
   * value must be from range [0, 3600].
   * @param minReadySec minReadySec or {@code null} for none
   */
  public InstanceGroupManagerUpdatePolicy setMinReadySec(java.lang.Integer minReadySec) {
    this.minReadySec = minReadySec;
    return this;
  }

  /**
   * Minimal action to be taken on an instance. The order of action types is: RESTART < REPLACE.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinimalAction() {
    return minimalAction;
  }

  /**
   * Minimal action to be taken on an instance. The order of action types is: RESTART < REPLACE.
   * @param minimalAction minimalAction or {@code null} for none
   */
  public InstanceGroupManagerUpdatePolicy setMinimalAction(java.lang.String minimalAction) {
    this.minimalAction = minimalAction;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * @param type type or {@code null} for none
   */
  public InstanceGroupManagerUpdatePolicy setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public InstanceGroupManagerUpdatePolicy set(String fieldName, Object value) {
    return (InstanceGroupManagerUpdatePolicy) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerUpdatePolicy clone() {
    return (InstanceGroupManagerUpdatePolicy) super.clone();
  }

}
