/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-01-11 18:31:16 UTC)
 * on 2017-01-20 at 04:29:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Provides the configuration for non-admin_activity logging for a service. Controls exemptions and
 * specific log sub-types.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AuditConfig extends com.google.api.client.json.GenericJson {

  /**
   * The configuration for each type of logging
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AuditLogConfig> auditLogConfigs;

  /**
   * Specifies the identities that are exempted from "data access" audit logging for the `service`
   * specified above. Follows the same format of Binding.members.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> exemptedMembers;

  /**
   * Specifies a service that will be enabled for audit logging. For example, `resourcemanager`,
   * `storage`, `compute`. `allServices` is a special value that covers all services.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String service;

  /**
   * The configuration for each type of logging
   * @return value or {@code null} for none
   */
  public java.util.List<AuditLogConfig> getAuditLogConfigs() {
    return auditLogConfigs;
  }

  /**
   * The configuration for each type of logging
   * @param auditLogConfigs auditLogConfigs or {@code null} for none
   */
  public AuditConfig setAuditLogConfigs(java.util.List<AuditLogConfig> auditLogConfigs) {
    this.auditLogConfigs = auditLogConfigs;
    return this;
  }

  /**
   * Specifies the identities that are exempted from "data access" audit logging for the `service`
   * specified above. Follows the same format of Binding.members.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExemptedMembers() {
    return exemptedMembers;
  }

  /**
   * Specifies the identities that are exempted from "data access" audit logging for the `service`
   * specified above. Follows the same format of Binding.members.
   * @param exemptedMembers exemptedMembers or {@code null} for none
   */
  public AuditConfig setExemptedMembers(java.util.List<java.lang.String> exemptedMembers) {
    this.exemptedMembers = exemptedMembers;
    return this;
  }

  /**
   * Specifies a service that will be enabled for audit logging. For example, `resourcemanager`,
   * `storage`, `compute`. `allServices` is a special value that covers all services.
   * @return value or {@code null} for none
   */
  public java.lang.String getService() {
    return service;
  }

  /**
   * Specifies a service that will be enabled for audit logging. For example, `resourcemanager`,
   * `storage`, `compute`. `allServices` is a special value that covers all services.
   * @param service service or {@code null} for none
   */
  public AuditConfig setService(java.lang.String service) {
    this.service = service;
    return this;
  }

  @Override
  public AuditConfig set(String fieldName, Object value) {
    return (AuditConfig) super.set(fieldName, value);
  }

  @Override
  public AuditConfig clone() {
    return (AuditConfig) super.clone();
  }

}
