/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-10 at 16:28:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstancesStartWithEncryptionKeyRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstancesStartWithEncryptionKeyRequest extends com.google.api.client.json.GenericJson {

  /**
   * Array of disks associated with this instance that are protected with a customer-supplied
   * encryption key.
   *
   * In order to start the instance, the disk url and its corresponding key must be provided.
   *
   * If the disk is not protected with a customer-supplied encryption key it should not be
   * specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomerEncryptionKeyProtectedDisk> disks;

  static {
    // hack to force ProGuard to consider CustomerEncryptionKeyProtectedDisk used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(CustomerEncryptionKeyProtectedDisk.class);
  }

  /**
   * Decrypts data associated with an instance that is protected with a customer-supplied encryption
   * key.
   *
   * If the instance you are starting is protected with a customer-supplied encryption key, the
   * correct key must be provided otherwise the instance start will not succeed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomerEncryptionKey instanceEncryptionKey;

  /**
   * Array of disks associated with this instance that are protected with a customer-supplied
   * encryption key.
   *
   * In order to start the instance, the disk url and its corresponding key must be provided.
   *
   * If the disk is not protected with a customer-supplied encryption key it should not be
   * specified.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomerEncryptionKeyProtectedDisk> getDisks() {
    return disks;
  }

  /**
   * Array of disks associated with this instance that are protected with a customer-supplied
   * encryption key.
   *
   * In order to start the instance, the disk url and its corresponding key must be provided.
   *
   * If the disk is not protected with a customer-supplied encryption key it should not be
   * specified.
   * @param disks disks or {@code null} for none
   */
  public InstancesStartWithEncryptionKeyRequest setDisks(java.util.List<CustomerEncryptionKeyProtectedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * Decrypts data associated with an instance that is protected with a customer-supplied encryption
   * key.
   *
   * If the instance you are starting is protected with a customer-supplied encryption key, the
   * correct key must be provided otherwise the instance start will not succeed.
   * @return value or {@code null} for none
   */
  public CustomerEncryptionKey getInstanceEncryptionKey() {
    return instanceEncryptionKey;
  }

  /**
   * Decrypts data associated with an instance that is protected with a customer-supplied encryption
   * key.
   *
   * If the instance you are starting is protected with a customer-supplied encryption key, the
   * correct key must be provided otherwise the instance start will not succeed.
   * @param instanceEncryptionKey instanceEncryptionKey or {@code null} for none
   */
  public InstancesStartWithEncryptionKeyRequest setInstanceEncryptionKey(CustomerEncryptionKey instanceEncryptionKey) {
    this.instanceEncryptionKey = instanceEncryptionKey;
    return this;
  }

  @Override
  public InstancesStartWithEncryptionKeyRequest set(String fieldName, Object value) {
    return (InstancesStartWithEncryptionKeyRequest) super.set(fieldName, value);
  }

  @Override
  public InstancesStartWithEncryptionKeyRequest clone() {
    return (InstancesStartWithEncryptionKeyRequest) super.clone();
  }

}
