/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-03 at 18:04:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a customer-supplied encryption key
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomerEncryptionKey extends com.google.api.client.json.GenericJson {

  /**
   * The name of the encryption key that is stored in Google Cloud KMS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kmsKeyName;

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either
   * encrypt or decrypt this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rawKey;

  /**
   * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to
   * either encrypt or decrypt this resource.
   *
   * The key must meet the following requirements before you can provide it to Compute Engine:   -
   * The key is wrapped using a RSA public key certificate provided by Google.  - After being
   * wrapped, the key must be encoded in RFC 4648 base64 encoding.  Get the RSA public key
   * certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-
   * csek-ingress.pem
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rsaEncryptedKey;

  /**
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
   * that protects this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha256;

  /**
   * The name of the encryption key that is stored in Google Cloud KMS.
   * @return value or {@code null} for none
   */
  public java.lang.String getKmsKeyName() {
    return kmsKeyName;
  }

  /**
   * The name of the encryption key that is stored in Google Cloud KMS.
   * @param kmsKeyName kmsKeyName or {@code null} for none
   */
  public CustomerEncryptionKey setKmsKeyName(java.lang.String kmsKeyName) {
    this.kmsKeyName = kmsKeyName;
    return this;
  }

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either
   * encrypt or decrypt this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getRawKey() {
    return rawKey;
  }

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either
   * encrypt or decrypt this resource.
   * @param rawKey rawKey or {@code null} for none
   */
  public CustomerEncryptionKey setRawKey(java.lang.String rawKey) {
    this.rawKey = rawKey;
    return this;
  }

  /**
   * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to
   * either encrypt or decrypt this resource.
   *
   * The key must meet the following requirements before you can provide it to Compute Engine:   -
   * The key is wrapped using a RSA public key certificate provided by Google.  - After being
   * wrapped, the key must be encoded in RFC 4648 base64 encoding.  Get the RSA public key
   * certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-
   * csek-ingress.pem
   * @return value or {@code null} for none
   */
  public java.lang.String getRsaEncryptedKey() {
    return rsaEncryptedKey;
  }

  /**
   * Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to
   * either encrypt or decrypt this resource.
   *
   * The key must meet the following requirements before you can provide it to Compute Engine:   -
   * The key is wrapped using a RSA public key certificate provided by Google.  - After being
   * wrapped, the key must be encoded in RFC 4648 base64 encoding.  Get the RSA public key
   * certificate provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-
   * csek-ingress.pem
   * @param rsaEncryptedKey rsaEncryptedKey or {@code null} for none
   */
  public CustomerEncryptionKey setRsaEncryptedKey(java.lang.String rsaEncryptedKey) {
    this.rsaEncryptedKey = rsaEncryptedKey;
    return this;
  }

  /**
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
   * that protects this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha256() {
    return sha256;
  }

  /**
   * [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
   * that protects this resource.
   * @param sha256 sha256 or {@code null} for none
   */
  public CustomerEncryptionKey setSha256(java.lang.String sha256) {
    this.sha256 = sha256;
    return this;
  }

  @Override
  public CustomerEncryptionKey set(String fieldName, Object value) {
    return (CustomerEncryptionKey) super.set(fieldName, value);
  }

  @Override
  public CustomerEncryptionKey clone() {
    return (CustomerEncryptionKey) super.clone();
  }

}
