/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-10 at 07:11:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The location in Cloud Storage and naming method of the daily usage report. Contains bucket_name
 * and report_name prefix.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UsageExportLocation extends com.google.api.client.json.GenericJson {

  /**
   * The name of an existing bucket in Cloud Storage where the usage report object is stored. The
   * Google Service Account is granted write access to this bucket. This can either be the bucket
   * name by itself, such as example-bucket, or the bucket name with gs:// or
   * https://storage.googleapis.com/ in front of it, such as gs://example-bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucketName;

  /**
   * An optional prefix for the name of the usage report object stored in bucketName. If not
   * supplied, defaults to usage. The report is stored as a CSV file named
   * report_name_prefix_gce_YYYYMMDD.csv where YYYYMMDD is the day of the usage according to Pacific
   * Time. If you supply a prefix, it should conform to Cloud Storage object naming conventions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportNamePrefix;

  /**
   * The name of an existing bucket in Cloud Storage where the usage report object is stored. The
   * Google Service Account is granted write access to this bucket. This can either be the bucket
   * name by itself, such as example-bucket, or the bucket name with gs:// or
   * https://storage.googleapis.com/ in front of it, such as gs://example-bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucketName() {
    return bucketName;
  }

  /**
   * The name of an existing bucket in Cloud Storage where the usage report object is stored. The
   * Google Service Account is granted write access to this bucket. This can either be the bucket
   * name by itself, such as example-bucket, or the bucket name with gs:// or
   * https://storage.googleapis.com/ in front of it, such as gs://example-bucket.
   * @param bucketName bucketName or {@code null} for none
   */
  public UsageExportLocation setBucketName(java.lang.String bucketName) {
    this.bucketName = bucketName;
    return this;
  }

  /**
   * An optional prefix for the name of the usage report object stored in bucketName. If not
   * supplied, defaults to usage. The report is stored as a CSV file named
   * report_name_prefix_gce_YYYYMMDD.csv where YYYYMMDD is the day of the usage according to Pacific
   * Time. If you supply a prefix, it should conform to Cloud Storage object naming conventions.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportNamePrefix() {
    return reportNamePrefix;
  }

  /**
   * An optional prefix for the name of the usage report object stored in bucketName. If not
   * supplied, defaults to usage. The report is stored as a CSV file named
   * report_name_prefix_gce_YYYYMMDD.csv where YYYYMMDD is the day of the usage according to Pacific
   * Time. If you supply a prefix, it should conform to Cloud Storage object naming conventions.
   * @param reportNamePrefix reportNamePrefix or {@code null} for none
   */
  public UsageExportLocation setReportNamePrefix(java.lang.String reportNamePrefix) {
    this.reportNamePrefix = reportNamePrefix;
    return this;
  }

  @Override
  public UsageExportLocation set(String fieldName, Object value) {
    return (UsageExportLocation) super.set(fieldName, value);
  }

  @Override
  public UsageExportLocation clone() {
    return (UsageExportLocation) super.clone();
  }

}
