/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-11 at 10:52:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Encapsulates numeric value that can be either absolute or relative.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FixedOrPercent extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Absolute value calculated based on mode: mode = fixed -> calculated = fixed =
   * percent -> calculated = ceiling(percent/100 * base_value)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer calculated;

  /**
   * fixed must be non-negative.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer fixed;

  /**
   * percent must belong to [0, 100].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer percent;

  /**
   * [Output Only] Absolute value calculated based on mode: mode = fixed -> calculated = fixed =
   * percent -> calculated = ceiling(percent/100 * base_value)
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCalculated() {
    return calculated;
  }

  /**
   * [Output Only] Absolute value calculated based on mode: mode = fixed -> calculated = fixed =
   * percent -> calculated = ceiling(percent/100 * base_value)
   * @param calculated calculated or {@code null} for none
   */
  public FixedOrPercent setCalculated(java.lang.Integer calculated) {
    this.calculated = calculated;
    return this;
  }

  /**
   * fixed must be non-negative.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getFixed() {
    return fixed;
  }

  /**
   * fixed must be non-negative.
   * @param fixed fixed or {@code null} for none
   */
  public FixedOrPercent setFixed(java.lang.Integer fixed) {
    this.fixed = fixed;
    return this;
  }

  /**
   * percent must belong to [0, 100].
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPercent() {
    return percent;
  }

  /**
   * percent must belong to [0, 100].
   * @param percent percent or {@code null} for none
   */
  public FixedOrPercent setPercent(java.lang.Integer percent) {
    this.percent = percent;
    return this;
  }

  @Override
  public FixedOrPercent set(String fieldName, Object value) {
    return (FixedOrPercent) super.set(fieldName, value);
  }

  @Override
  public FixedOrPercent clone() {
    return (FixedOrPercent) super.clone();
  }

}
